/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.modeling;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MField;
import cn.vertxup.atom.domain.tables.pojos.MJoin;
import io.vertx.tp.atom.cv.em.IdMode;
import io.vertx.tp.atom.cv.em.ModelType;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.modeling.element.DataKey;
import io.vertx.tp.error._417RelationCounterException;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jooq.tools.StringUtils;

class Bridge {
    Bridge() {
    }

    static void connect(Model model, Set<Schema> schemaSet, Consumer<Set<Schema>> consumer) {
        Set found;
        Set<MJoin> joins = model.dbJoins();
        if (!joins.isEmpty() && !(found = schemaSet.stream().filter(Objects::nonNull).filter(schema -> Objects.nonNull(schema.getEntity())).filter(schema -> StringUtils.equals((String)schema.namespace(), (String)model.namespace())).filter(schema -> joins.stream().filter(Objects::nonNull).map(MJoin::getEntity).filter(Objects::nonNull).anyMatch(entity -> entity.equals(schema.identifier()))).collect(Collectors.toSet())).isEmpty()) {
            consumer.accept(found);
        }
    }

    static void connect(Model model, Set<Schema> found) {
        Set<Schema> schemata = model.schemata();
        assert (null != schemata) : "[OxA] \u5f53\u524dSchema\u96c6\u5408\u4e0d\u53ef\u80fd\u4e3a\u7a7a\uff01";
        schemata.clear();
        schemata.addAll(found);
        Set<MAttribute> attributes = model.dbAttributes();
        ModelType type = (ModelType)Ut.toEnum(ModelType.class, (String)model.dbModel().getType());
        if (1 == schemata.size() && ModelType.DIRECT == type) {
            Schema schema = schemata.iterator().next();
            attributes.stream().filter(attribute -> Ut.isNil((String)attribute.getSource())).forEach(attribute -> attribute.setSource(schema.identifier()));
        }
    }

    static void connect(Model model, String unique) {
        DataKey key = DataKey.create(unique);
        Set<MJoin> joins = model.dbJoins();
        Set<Schema> schema = model.schemata();
        Fn.outWeb((joins.size() < 1 || schema.size() < 1 || schema.size() < joins.size() ? 1 : 0) != 0, _417RelationCounterException.class, (Object[])new Object[]{Bridge.class, model.dbModel().getIdentifier(), schema.size(), joins.size()});
        if (1 < schema.size()) {
            model.dbModel().setType(ModelType.JOINED.name());
            if (schema.size() == joins.size()) {
                Set targets = joins.stream().map(MJoin::getEntityKey).filter(Objects::nonNull).collect(Collectors.toSet());
                if (1 == targets.size()) {
                    key.setMode(IdMode.JOIN_KEY);
                } else {
                    key.setMode(IdMode.JOIN_MULTI);
                }
            } else {
                key.setMode(IdMode.JOIN_COLLECTION);
            }
        } else {
            model.dbModel().setType(ModelType.DIRECT.name());
            Schema schemaObj = schema.iterator().next();
            List<MField> fields = schemaObj.getPrimaryKeys();
            if (1 == fields.size()) {
                key.setMode(IdMode.DIRECT);
            } else {
                key.setMode(IdMode.COLLECTION);
            }
        }
        model.key(key);
    }
}

