/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.config;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MField;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.cv.em.AttributeType;
import io.vertx.tp.atom.modeling.config.AoRule;
import io.vertx.up.commune.element.TypeField;
import io.vertx.up.eon.KName;
import io.vertx.up.eon.em.DataFormat;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AoAttribute
implements Serializable {
    private final transient DataFormat dataFormat;
    private final transient List<TypeField> shapes = new ArrayList<TypeField>();
    private final transient TypeField type;
    private transient AoRule rule;

    public AoAttribute(MAttribute attribute, MField sourceField) {
        Class<Object> configType;
        AttributeType type = (AttributeType)Ut.toEnum(attribute::getType, AttributeType.class, (Enum)AttributeType.INTERNAL);
        Boolean isArray = Objects.isNull(attribute.getIsArray()) ? Boolean.FALSE : attribute.getIsArray();
        JsonObject config = Ut.toJObject((String)attribute.getSourceConfig());
        JsonObject reference = Ut.toJObject((String)attribute.getSourceReference());
        DataFormat format = (DataFormat)Ut.toEnum(() -> config.getString("format"), DataFormat.class, (Enum)DataFormat.Elementary);
        if (isArray.booleanValue()) {
            format = DataFormat.JsonArray;
        }
        this.dataFormat = format;
        if (DataFormat.Elementary == format) {
            configType = Ut.clazz((String)config.getString("type"), String.class);
        } else {
            Class<Object> clazz = configType = DataFormat.JsonArray == format ? JsonArray.class : JsonObject.class;
        }
        Class<Object> attributeType = AttributeType.INTERNAL == type ? (KName.Modeling.VALUE_SET.contains(attribute.getSourceField()) ? configType : (Objects.isNull(sourceField) ? null : Ut.clazz((String)sourceField.getType(), null))) : configType;
        this.type = TypeField.create((String)attribute.getName(), (String)attribute.getAlias(), (Class)attributeType);
        JsonArray fields = Ut.sureJArray((JsonArray)config.getJsonArray("fields"));
        Ut.itJArray((JsonArray)fields).forEach(item -> {
            String field = item.getString("field");
            if (Ut.notNil((String)field)) {
                String alias = item.getString("alias", null);
                Class subType = Ut.clazz((String)item.getString("type"), String.class);
                this.shapes.add(TypeField.create((String)field, (String)alias, (Class)subType));
            }
        });
        if (DataFormat.Elementary != format) {
            this.type.add(this.shapes);
        }
        if (reference.containsKey("rule")) {
            JsonObject ruleData = Ut.sureJObject((JsonObject)reference.getJsonObject("rule"));
            this.rule = (AoRule)Ut.deserialize((JsonObject)ruleData, AoRule.class);
            this.rule.type(attributeType);
            this.type.ruleUnique(this.rule.getUnique());
        }
    }

    public Class<?> typeCls() {
        return this.type.type();
    }

    public TypeField type() {
        return this.type;
    }

    public List<TypeField> types() {
        return this.shapes;
    }

    public AoRule rule() {
        return this.rule;
    }

    public DataFormat format() {
        return this.dataFormat;
    }
}

