/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MModel;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.config.AoAttribute;
import io.vertx.up.commune.element.TypeAtom;
import io.vertx.up.commune.element.TypeField;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;

class AoDefine {
    private final transient Model modelRef;
    private final transient String identifier;
    private final transient TypeAtom typeAtom = TypeAtom.create();

    AoDefine(Model modelRef) {
        this.modelRef = modelRef;
        this.identifier = modelRef.identifier();
        modelRef.dbAttributes().forEach(attr -> {
            AoAttribute aoAttr;
            TypeField typeField;
            String name = attr.getName();
            if (Ut.notNil((String)name) && Objects.nonNull(typeField = Objects.isNull(aoAttr = modelRef.attribute(name)) ? TypeField.create((String)name, (String)attr.getAlias()) : aoAttr.type())) {
                this.typeAtom.add(typeField);
            }
        });
    }

    Model model() {
        return this.modelRef;
    }

    String identifier() {
        return this.identifier;
    }

    String sigma() {
        return this.sure(MModel::getSigma);
    }

    String language() {
        return this.sure(MModel::getLanguage);
    }

    AoAttribute attribute(String attributeName) {
        return this.modelRef.attribute(attributeName);
    }

    Set<String> attributeNames() {
        return this.modelRef.dbAttributes().stream().map(MAttribute::getName).filter(Ut::notNil).collect(Collectors.toSet());
    }

    ConcurrentMap<String, String> alias() {
        return this.typeAtom.alias();
    }

    TypeAtom shape() {
        return this.typeAtom;
    }

    ConcurrentMap<String, Class<?>> typeCls() {
        return this.modelRef.typeCls();
    }

    ConcurrentMap<String, TypeField> types() {
        return this.modelRef.types();
    }

    Class<?> type(String field) {
        return this.modelRef.typeCls().getOrDefault(field, null);
    }

    private <T> T sure(Function<MModel, T> function) {
        MModel model = this.model().dbModel();
        if (Objects.isNull(model)) {
            return null;
        }
        return function.apply(model);
    }
}

