/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import io.vertx.tp.atom.modeling.Model;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class AoMarker {
    private final transient Model modelRef;

    AoMarker(Model modelRef) {
        this.modelRef = modelRef;
    }

    boolean trackable() {
        Boolean result = this.modelRef.dbModel().getIsTrack();
        return Objects.isNull(result) ? Boolean.FALSE : Boolean.TRUE;
    }

    Set<String> track(Boolean defaultValue) {
        return this.audit(MAttribute::getIsTrack, defaultValue);
    }

    Set<String> in(Boolean defaultValue) {
        return this.audit(MAttribute::getIsSyncIn, defaultValue);
    }

    Set<String> out(Boolean defaultValue) {
        return this.audit(MAttribute::getIsSyncOut, defaultValue);
    }

    Set<String> confirm(Boolean defaultValue) {
        return this.audit(MAttribute::getIsConfirm, defaultValue);
    }

    private Set<String> audit(Function<MAttribute, Boolean> function, Boolean defaultValue) {
        if (defaultValue.booleanValue()) {
            return this.audit(attr -> {
                Boolean result = (Boolean)function.apply((MAttribute)attr);
                return Objects.isNull(result) ? Boolean.TRUE : result;
            });
        }
        return this.audit(attr -> {
            Boolean result = (Boolean)function.apply((MAttribute)attr);
            return Objects.isNull(result) ? Boolean.FALSE : result == false;
        });
    }

    private Set<String> audit(Predicate<MAttribute> predicate) {
        return this.modelRef.dbAttributes().stream().filter(Objects::nonNull).filter(predicate).map(MAttribute::getName).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

