/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.reference;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.config.AoAttribute;
import io.vertx.tp.atom.modeling.config.AoRule;
import io.vertx.tp.atom.modeling.reference.RRuler;
import io.vertx.up.atom.Kv;
import io.vertx.up.eon.em.DataFormat;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RResult
implements Serializable {
    private final transient AoRule rule;
    private final transient DataFormat format;
    private final transient Class<?> type;
    private final transient List<Kv<String, String>> joined = new ArrayList<Kv<String, String>>();
    private final transient String sourceField;

    public RResult(MAttribute attribute, AoAttribute aoAttr) {
        this.type = aoAttr.typeCls();
        this.format = aoAttr.format();
        this.rule = aoAttr.rule();
        this.sourceField = attribute.getSourceField();
        JsonObject sourceReference = Ut.toJObject((String)attribute.getSourceReference());
        Object connect = sourceReference.getValue("connect");
        if (Objects.nonNull(connect)) {
            if (connect instanceof String) {
                String currentField2 = (String)connect;
                String referenceField2 = attribute.getSourceField();
                this.joined.add((Kv<String, String>)Kv.create((Object)referenceField2, (Object)currentField2));
            } else if (connect instanceof JsonObject) {
                JsonObject mapping = (JsonObject)connect;
                Ut.itJObject((JsonObject)mapping, (currentField, referenceField) -> this.joined.add((Kv<String, String>)Kv.create((Object)referenceField, (Object)currentField)));
            }
        }
    }

    public DataFormat format() {
        return this.format;
    }

    public Class<?> typeData() {
        return this.type;
    }

    public List<Kv<String, String>> joined() {
        return this.joined;
    }

    public String sourceField() {
        return this.sourceField;
    }

    public JsonArray runRuler(JsonArray source) {
        JsonArray processed = RRuler.required(source, this.rule);
        processed = RRuler.duplicated(processed, this.rule);
        return processed;
    }
}

