/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.refine;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.cv.AoCache;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.refine.AoStore;
import io.vertx.tp.modular.dao.AoDao;
import io.vertx.tp.modular.jdbc.Pin;
import io.vertx.tp.optic.robin.Switcher;
import io.vertx.up.commune.config.Database;
import io.vertx.up.commune.config.Identity;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Supplier;

class AoImpl {
    AoImpl() {
    }

    static Schema toSchema(String appName, JsonObject schemaJson) {
        Schema schemaObj = AoImpl.toSchema(appName);
        schemaObj.fromJson(schemaJson);
        return schemaObj;
    }

    static Schema toSchema(String appName, String file) {
        Schema schemaObj = AoImpl.toSchema(appName);
        schemaObj.fromFile(file);
        return schemaObj;
    }

    static Model toModel(String appName, JsonObject modelJson) {
        Model modelObj = AoImpl.toModel(appName);
        modelObj.fromJson(modelJson);
        return modelObj;
    }

    static Model toModel(String appName, String file) {
        Model modelObj = AoImpl.toModel(appName);
        modelObj.fromFile(file);
        return modelObj;
    }

    static Switcher toSwitcher(Identity identity, JsonObject options) {
        return (Switcher)Fn.pool(AoCache.POOL_SWITCHER, (Object)identity.hashCode(), () -> {
            Class<?> implSwitcher = AoStore.clazzSwitcher();
            return (Switcher)Ut.instance(implSwitcher, (Object[])new Object[]{identity, options});
        });
    }

    private static Schema toSchema(String appName) {
        Class<?> implSchema = AoStore.clazzSchema();
        return (Schema)Ut.instance(implSchema, (Object[])new Object[]{AoStore.toNamespace(appName)});
    }

    private static Model toModel(String appName) {
        Class<?> implModel = AoStore.clazzModel();
        return (Model)Ut.instance(implModel, (Object[])new Object[]{AoStore.toNamespace(appName)});
    }

    static DataAtom toAtom(JsonObject options) {
        String identifier = options.getString("identifier");
        String name = options.getString("name");
        return DataAtom.get(name, identifier);
    }

    static AoDao toDao(Database database, DataAtom atom) {
        return AoImpl.toDao(database, () -> atom);
    }

    static AoDao toDao(Database database, Supplier<DataAtom> supplier) {
        if (Objects.isNull(database)) {
            return null;
        }
        DataAtom atom = supplier.get();
        if (Objects.isNull(atom)) {
            return null;
        }
        Pin pin = Pin.getInstance();
        return (AoDao)Fn.pool(AoCache.POOL_T_DAO, (Object)atom.identifier(), () -> pin.getDao(database).mount(atom));
    }
}

