/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.modular.jooq.internal.Jq;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Batch;
import org.jooq.DSLContext;
import org.jooq.InsertReturningStep;
import org.jooq.InsertSetMoreStep;

class JQInsert {
    private final transient DSLContext context;

    JQInsert(DSLContext context) {
        this.context = context;
    }

    DataEvent insert(DataEvent event) {
        return (DataEvent)this.context.transactionResult(configuration -> Jq.doWrite(this.getClass(), event, (table, matrix) -> {
            InsertReturningStep step = this.stepInsert((String)table, (DataMatrix)matrix);
            return step.execute();
        }, Ut::isPositive));
    }

    DataEvent insertBatch(DataEvent event) {
        return (DataEvent)this.context.transactionResult(configuration -> Jq.doWrites(this.getClass(), event, (table, matrixList) -> {
            Batch batch = this.prepareBatch((String)table, (List<DataMatrix>)matrixList);
            return batch.execute();
        }, Ut::isPositive));
    }

    private Batch prepareBatch(String table, List<DataMatrix> matrices) {
        ArrayList batchOps = new ArrayList();
        matrices.stream().map(matrix -> this.stepInsert(table, (DataMatrix)matrix)).forEach(batchOps::add);
        return this.context.batch(batchOps);
    }

    private InsertReturningStep stepInsert(String table, DataMatrix matrix) {
        InsertSetMoreStep steps = (InsertSetMoreStep)this.context.insertInto(Jq.toTable(table));
        Jq.inArgument(matrix, (arg_0, arg_1) -> ((InsertSetMoreStep)steps).set(arg_0, arg_1));
        return steps;
    }
}

