/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq.internal;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.modular.jooq.internal.Argument;
import io.vertx.tp.modular.jooq.internal.Event;
import io.vertx.tp.modular.jooq.internal.Meta;
import io.vertx.tp.modular.jooq.internal.Query;
import io.vertx.tp.modular.jooq.internal.Reader;
import io.vertx.tp.modular.jooq.internal.Where;
import io.vertx.tp.modular.jooq.internal.Writer;
import io.vertx.tp.modular.query.Ingest;
import io.vertx.up.log.Annal;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;

public class Jq {
    private static final Annal LOGGER = Annal.get(Jq.class);

    public static Field toField(String field, Set<DataMatrix> matrix, ConcurrentMap<String, String> fieldMap) {
        return Meta.field(field, matrix, fieldMap);
    }

    public static Table<Record> toTable(String name) {
        return Meta.table(name);
    }

    public static Table<Record> natureJoin(ConcurrentMap<String, String> aliasMap) {
        return Meta.natureJoin(aliasMap);
    }

    public static Table<Record> leftJoin(String leader, ConcurrentMap<String, String> vectors, ConcurrentMap<String, String> aliasMap) {
        return Meta.leftJoin(leader, vectors, aliasMap);
    }

    public static <T> void inArgument(DataMatrix matrix, BiFunction<Field, Object, T> function) {
        Argument.set(matrix, function);
    }

    public static Condition onKey(DataMatrix matrix) {
        return Jq.onMonitor(() -> Where.key(matrix), "onKey");
    }

    public static Condition onKeys(List<DataMatrix> matrixList) {
        return Jq.onMonitor(() -> Where.keys(matrixList), "onKeys");
    }

    private static Condition onMonitor(Supplier<Condition> supplier, String method) {
        Condition condition = supplier.get();
        LOGGER.debug("[ Ox ] \u65b9\u6cd5\uff1a{0}\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a{1}", new Object[]{method, condition});
        return condition;
    }

    public static DataEvent doWrite(Class<?> clazz, DataEvent event, BiFunction<String, DataMatrix, Integer> actor) {
        return Writer.doWrite(clazz, event, actor, null);
    }

    public static DataEvent doWrite(Class<?> clazz, DataEvent event, BiFunction<String, DataMatrix, Integer> actor, Predicate<Integer> predicate) {
        return Writer.doWrite(clazz, event, actor, predicate);
    }

    public static DataEvent doWrites(Class<?> clazz, DataEvent event, BiFunction<String, List<DataMatrix>, int[]> actor) {
        return Writer.doWrites(clazz, event, actor, null);
    }

    public static DataEvent doWrites(Class<?> clazz, DataEvent event, BiFunction<String, List<DataMatrix>, int[]> actor, Predicate<int[]> predicate) {
        return Writer.doWrites(clazz, event, actor, predicate);
    }

    public static DataEvent doRead(Class<?> clazz, DataEvent event, BiFunction<String, DataMatrix, Record> actor) {
        return Reader.doRead(clazz, event, actor);
    }

    public static DataEvent doReads(Class<?> clazz, DataEvent event, BiFunction<String, List<DataMatrix>, Record[]> actor) {
        return Reader.doReads(clazz, event, actor);
    }

    public static DataEvent doCount(Class<?> clazz, DataEvent event, BiFunction<Set<String>, Ingest, Long> actor) {
        return Query.doCount(clazz, event, actor);
    }

    public static DataEvent doQuery(Class<?> clazz, DataEvent event, BiFunction<Set<String>, Ingest, Record> actor) {
        return Query.doQuery(clazz, event, actor);
    }

    public static DataEvent doQuery(Class<?> clazz, DataEvent event, BiFunction<Set<String>, Ingest, Record[]> actor, BiFunction<Set<String>, Ingest, Long> counter) {
        return Query.doQuery(clazz, event, actor, counter);
    }

    public static DataEvent doQueryAll(Class<?> clazz, DataEvent event, BiFunction<Set<String>, Ingest, Record[]> actor) {
        return Query.doQuery(clazz, event, actor, null);
    }

    public static Boolean onBoolean(DataEvent event, Function<DataEvent, DataEvent> executor) {
        return (Boolean)Event.onBoolean(event, executor);
    }

    public static Long onCount(DataEvent event, Function<DataEvent, DataEvent> executor) {
        return Event.onCount(event, executor);
    }

    public static io.vertx.up.commune.Record onRecord(DataEvent event, Function<DataEvent, DataEvent> executor) {
        return (io.vertx.up.commune.Record)Event.onRecord(event, executor, false);
    }

    public static io.vertx.up.commune.Record[] onRecords(DataEvent event, Function<DataEvent, DataEvent> executor) {
        return (io.vertx.up.commune.Record[])Event.onRecord(event, executor, true);
    }

    public static JsonObject onPagination(DataEvent event, Function<DataEvent, DataEvent> executor) {
        return Event.onPagination(event, executor);
    }
}

