/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq.internal;

import io.vertx.tp.atom.cv.em.ModelType;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.error._417TableCounterException;
import io.vertx.tp.modular.jooq.internal.Data;
import io.vertx.tp.modular.query.Ingest;
import io.vertx.up.fn.Fn;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.jooq.Record;

class Query {
    Query() {
    }

    static DataEvent doCount(Class<?> clazz, DataEvent event, BiFunction<Set<String>, Ingest, Long> consumer) {
        Ingest ingest = Query.getIngest(event);
        ConcurrentMap<String, DataMatrix> matrix = Query.getMatrix(clazz, event);
        Long counter = consumer.apply(matrix.keySet(), ingest);
        event.stored(counter);
        return event;
    }

    static DataEvent doQuery(Class<?> clazz, DataEvent event, BiFunction<Set<String>, Ingest, Record> consumer) {
        Ingest ingest = Query.getIngest(event);
        ConcurrentMap<String, DataMatrix> matrix = Query.getMatrix(clazz, event);
        DataTpl tpl = event.getTpl();
        Set<String> projection = event.getProjection();
        Record record = consumer.apply(matrix.keySet(), ingest);
        event.stored(Data.doJoin(matrix.keySet(), new Record[]{record}, tpl, projection));
        return event;
    }

    static DataEvent doQuery(Class<?> clazz, DataEvent event, BiFunction<Set<String>, Ingest, Record[]> consumer, BiFunction<Set<String>, Ingest, Long> counter) {
        Ingest ingest = Query.getIngest(event);
        ConcurrentMap<String, DataMatrix> matrix = Query.getMatrix(clazz, event);
        DataTpl tpl = event.getTpl();
        Set<String> projection = event.getProjection();
        Record[] records = consumer.apply(matrix.keySet(), ingest);
        event.stored(Data.doJoin(matrix.keySet(), records, tpl, projection));
        if (Objects.nonNull(counter)) {
            Long count = counter.apply(matrix.keySet(), ingest);
            event.stored(count);
        }
        return event;
    }

    private static Ingest getIngest(DataEvent event) {
        ModelType type = event.getType();
        Ingest ingest = Ingest.create(type);
        DataAtom atomRef = event.getTpl().atom();
        Ao.infoUca(Query.class, "\u67e5\u8be2\u89e3\u6790\u5668\uff1a{0}\uff0c\u64cd\u4f5c\u6a21\u578b\uff1a{1}", null == ingest ? null : ingest.getClass().getName(), atomRef.identifier());
        return ingest;
    }

    private static ConcurrentMap<String, DataMatrix> getMatrix(Class<?> clazz, DataEvent event) {
        ModelType type = event.getType();
        DataTpl tpl = event.getTpl();
        ConcurrentMap<String, DataMatrix> matrix = tpl.matrixData();
        if (ModelType.DIRECT == type) {
            Fn.outWeb((1 != matrix.size() ? 1 : 0) != 0, _417TableCounterException.class, (Object[])new Object[]{clazz, matrix.size()});
        } else if (ModelType.JOINED == type) {
            Fn.outWeb((1 >= matrix.size() ? 1 : 0) != 0, _417TableCounterException.class, (Object[])new Object[]{clazz, matrix.size()});
        }
        return matrix;
    }
}

