/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.cv.AoCache;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.config.AoAttribute;
import io.vertx.tp.atom.modeling.data.AoDefine;
import io.vertx.tp.atom.modeling.data.AoMarker;
import io.vertx.tp.atom.modeling.data.AoReference;
import io.vertx.tp.atom.modeling.data.AoUnique;
import io.vertx.tp.atom.modeling.data.Pool;
import io.vertx.tp.atom.modeling.reference.RQuery;
import io.vertx.tp.atom.modeling.reference.RQuote;
import io.vertx.tp.atom.modeling.reference.RResult;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.error._404ModelNotFoundException;
import io.vertx.tp.modular.phantom.AoPerformer;
import io.vertx.up.commune.compare.Vs;
import io.vertx.up.commune.element.TypeAtom;
import io.vertx.up.commune.rule.RuleUnique;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class DataAtom {
    private final transient AoDefine metadata;
    private final transient AoUnique ruler;
    private final transient AoMarker marker;
    private final transient AoReference reference;
    private final transient Vs vs;
    private final transient String unique;
    private final transient String appName;

    private DataAtom(Model model, String appName) {
        this.appName = appName;
        this.unique = Model.namespace(appName) + "-" + model.identifier();
        Integer modelCode = model.hashCode();
        this.metadata = (AoDefine)Fn.pool(Pool.META_INFO, (Object)modelCode, () -> new AoDefine(model));
        this.ruler = (AoUnique)Fn.pool(Pool.META_RULE, (Object)modelCode, () -> new AoUnique(model));
        this.marker = (AoMarker)Fn.pool(Pool.META_MARKER, (Object)modelCode, () -> new AoMarker(model));
        this.reference = (AoReference)Fn.pool(Pool.META_REFERENCE, (Object)modelCode, () -> new AoReference(model, appName));
        this.vs = Vs.create((String)this.unique, this.metadata.typeCls(), this.metadata.types());
    }

    public static DataAtom get(String appName, String identifier) {
        try {
            String unique = Model.namespace(appName) + "-" + identifier;
            AoPerformer performer = AoPerformer.getInstance(appName);
            Model model = (Model)Fn.pool(AoCache.POOL_MODELS, (Object)unique, () -> performer.fetchModel(identifier));
            DataAtom atom = new DataAtom(model, appName);
            Ao.infoAtom(DataAtom.class, "Model Information\uff1a<namespace>.<identifier> = {0}, model = {1}", unique, model.toJson().encode());
            return atom;
        }
        catch (_404ModelNotFoundException ignored) {
            return null;
        }
    }

    public String key(JsonObject options) {
        String hashCode = Ut.isNil((JsonObject)options) ? "" : String.valueOf(options.hashCode());
        return this.metadata.identifier() + "-" + hashCode;
    }

    public DataAtom atom(String identifier) {
        return DataAtom.get(this.appName, identifier);
    }

    public Set<String> attributeNames() {
        return this.metadata.attributeNames();
    }

    public AoAttribute attribute(String name) {
        return this.metadata.attribute(name);
    }

    public ConcurrentMap<String, String> alias() {
        return this.metadata.alias();
    }

    public Model model() {
        return this.metadata.model();
    }

    public String identifier() {
        return this.metadata.identifier();
    }

    public String sigma() {
        return this.metadata.sigma();
    }

    public String language() {
        return this.metadata.language();
    }

    public ConcurrentMap<String, Class<?>> type() {
        return this.metadata.typeCls();
    }

    public TypeAtom shape() {
        return this.metadata.shape();
    }

    public Class<?> type(String field) {
        return this.metadata.type(field);
    }

    public Vs vs() {
        return this.vs;
    }

    public ConcurrentMap<String, RQuote> refInput() {
        return this.reference.refInput();
    }

    public ConcurrentMap<String, RResult> refOutput() {
        return this.reference.refOutput();
    }

    public ConcurrentMap<String, RQuery> refQuery() {
        return this.reference.refQr();
    }

    public RuleUnique rule() {
        return this.ruler.rule();
    }

    public RuleUnique ruleDirect() {
        return this.ruler.ruleDirect();
    }

    public RuleUnique ruleSmart() {
        return this.ruler.ruleSmart();
    }

    public DataAtom ruleConnect(RuleUnique channelRule) {
        this.ruler.connect(channelRule);
        return this;
    }

    public Boolean trackable() {
        return this.marker.trackable();
    }

    public Set<String> falseTrack() {
        return this.marker.track(Boolean.FALSE);
    }

    public Set<String> trueTrack() {
        return this.marker.track(Boolean.TRUE);
    }

    public Set<String> falseIn() {
        return this.marker.in(Boolean.FALSE);
    }

    public Set<String> trueIn() {
        return this.marker.in(Boolean.TRUE);
    }

    public Set<String> falseOut() {
        return this.marker.out(Boolean.FALSE);
    }

    public Set<String> trueOut() {
        return this.marker.out(Boolean.TRUE);
    }

    public Set<String> falseConfirm() {
        return this.marker.confirm(Boolean.FALSE);
    }

    public Set<String> trueConfirm() {
        return this.marker.confirm(Boolean.TRUE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataAtom)) {
            return false;
        }
        DataAtom atom = (DataAtom)o;
        return this.unique.equals(atom.unique);
    }

    public int hashCode() {
        return Objects.hash(this.unique);
    }
}

