/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.data.DataAtom;
import java.util.Objects;

public class DataGroup {
    private final transient JsonArray data = new JsonArray();
    private final transient DataAtom atom;
    private final transient String identifier;

    private DataGroup(DataAtom atom) {
        this.atom = atom;
        this.identifier = atom.identifier();
    }

    public static DataGroup create(DataAtom atom) {
        return new DataGroup(atom);
    }

    public DataGroup add(JsonObject data) {
        this.data.add((Object)data);
        return this;
    }

    public DataGroup add(JsonArray data) {
        this.data.addAll(data);
        return this;
    }

    public DataGroup replace(JsonArray data) {
        this.data.clear();
        this.data.addAll(data);
        return this;
    }

    public JsonArray data() {
        return this.data;
    }

    public DataAtom atom() {
        return this.atom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataGroup)) {
            return false;
        }
        DataGroup dataGroup = (DataGroup)o;
        return this.identifier.equals(dataGroup.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

