/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.element.DataRow;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.up.log.Annal;
import java.util.List;
import java.util.Objects;

class Debug {
    private static final Annal LOGGER = Annal.get(Debug.class);

    Debug() {
    }

    public static void tpl(DataTpl tpl) {
        DataAtom atom = tpl.atom();
        Model model = atom.model();
        StringBuilder source = new StringBuilder();
        source.append("\n<TPL> -- \u4e3b\u952e\u6a21\u5f0f\uff1a").append((Object)model.key().getMode()).append("\n");
        source.append("\u6a21\u578b\u7c7b\u578b\uff1a").append(model.dbModel().getType()).append("\n");
        source.append("\u6620\u5c04\u5173\u7cfb -> \n\n");
        source.append(String.format("%-20s", "\u5c5e\u6027\u540d")).append(String.format("%-20s", "\u8868\u540d")).append("\n");
        tpl.appendConsole(source);
        LOGGER.debug(source.toString(), new Object[0]);
    }

    public static void io(List<DataRow> rows) {
        StringBuilder source = new StringBuilder();
        source.append("\n<Data> -- \u6570\u636e\u4fe1\u606f\uff1a").append("\n");
        rows.forEach(row -> row.appendConsole(source));
        LOGGER.debug(source.toString(), new Object[0]);
        StringBuilder json = new StringBuilder();
        json.append("\n");
        rows.stream().filter(item -> Objects.nonNull(item.getRecord())).forEach(item -> json.append(item.getRecord().toJson()).append("\n"));
        LOGGER.debug(json.toString(), new Object[0]);
    }
}

