/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.reference;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.ke.atom.specification.KJoin;
import io.vertx.tp.ke.atom.specification.KPoint;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.modular.dao.AoDao;
import io.vertx.tp.optic.DS;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.config.Database;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Function;

public class RDao {
    private final transient DataAtom atom;
    private final transient String source;
    private transient KJoin kJoin;

    public RDao(String appName, String source) {
        this.source = source;
        this.atom = DataAtom.get(appName, source);
    }

    public DataAtom atom() {
        return this.atom;
    }

    public String source() {
        return this.source;
    }

    public boolean isStatic() {
        return Objects.isNull(this.atom);
    }

    @Fluent
    public RDao bind(KJoin kJoin) {
        if (Objects.nonNull(kJoin) && Objects.isNull(this.atom)) {
            this.kJoin = kJoin;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RDao rDao = (RDao)o;
        return this.source.equals(rDao.source);
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }

    public JsonArray fetchBy(JsonObject condition) {
        if (Ux.Jooq.isEmpty((JsonObject)condition)) {
            return new JsonArray();
        }
        if (this.isStatic()) {
            Function<JsonObject, JsonArray> executor = this.executor();
            return executor.apply(condition);
        }
        AoDao daoD = this.daoD();
        Record[] records = daoD.fetch(condition);
        return Ut.toJArray((Record[])records);
    }

    public Future<JsonArray> fetchByAsync(JsonObject condition) {
        if (Ux.Jooq.isEmpty((JsonObject)condition)) {
            return Ux.futureA();
        }
        if (this.isStatic()) {
            Function<JsonObject, Future<JsonArray>> executor = this.executorAsync();
            return executor.apply(condition);
        }
        AoDao daoD = this.daoD();
        return daoD.fetchAsync(condition).compose(Ux::futureA);
    }

    private Function<JsonObject, JsonArray> executor() {
        return condition -> {
            KPoint source = this.kJoin.getSource();
            KPoint target = this.kJoin.point(condition);
            if (Objects.isNull(target)) {
                return Ux.Jooq.on((Class)source.getClassDao()).fetchJ(condition);
            }
            return Ux.Join.on().add(source.getClassDao(), source.getKeyJoin()).join(target.getClassDao(), target.getKeyJoin()).fetch(condition);
        };
    }

    private Function<JsonObject, Future<JsonArray>> executorAsync() {
        return condition -> {
            KPoint source = this.kJoin.getSource();
            KPoint target = this.kJoin.point(condition);
            if (Objects.isNull(target)) {
                return Ux.Jooq.on((Class)source.getClassDao()).fetchJAsync(condition);
            }
            return Ux.Join.on().add(source.getClassDao(), source.getKeyJoin()).join(target.getClassDao(), target.getKeyJoin()).fetchAsync(condition);
        };
    }

    private AoDao daoD() {
        return (AoDao)Ke.channelSync(DS.class, () -> null, ds -> {
            DataPool pool = ds.switchDs(this.atom.sigma());
            if (Objects.nonNull(pool)) {
                Database database = pool.getDatabase();
                return Ao.toDao(database, this.atom);
            }
            return null;
        });
    }
}

