/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.refine;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.init.AoPin;
import io.vertx.tp.atom.modeling.config.AoConfig;
import io.vertx.tp.optic.modeling.JsonModel;
import io.vertx.tp.optic.modeling.JsonSchema;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.util.Objects;

class AoStore {
    private static final String NS_PREFIX = "cn.originx.{0}";
    private static final String PATH_EXCEL = "runtime/excel/";
    private static final String PATH_JSON = "runtime/json/";
    private static final String PATH_ADJUSTER = "runtime/adjuster/config.json";
    private static final String PATH_MODELING = "runtime/adjuster/modeling";
    private static final AoConfig CONFIG = AoPin.getConfig();

    AoStore() {
    }

    static String toNamespace(String appName) {
        String prefix = CONFIG.getNamespace();
        if (Ut.isNil((String)prefix)) {
            prefix = NS_PREFIX;
        }
        return MessageFormat.format(prefix, appName);
    }

    static String defineExcel() {
        String excel = CONFIG.getDefineExcel();
        return Ut.isNil((String)excel) ? PATH_EXCEL : excel;
    }

    static String defineJson() {
        String json = CONFIG.getDefineJson();
        return Ut.isNil((String)json) ? PATH_JSON : json;
    }

    static JsonObject configAdjuster() {
        String adjuster = CONFIG.getConfigAdjuster();
        if (Ut.isNil((String)adjuster)) {
            adjuster = PATH_ADJUSTER;
        }
        return Ut.ioJObject((String)adjuster);
    }

    static JsonObject configModeling(String filename) {
        String modeling = CONFIG.getConfigModeling();
        if (Ut.isNil((String)modeling)) {
            modeling = PATH_MODELING;
        }
        String name = modeling.endsWith("/") ? modeling + filename + ".json" : modeling + "/" + filename + ".json";
        return Ut.ioJObject((String)name);
    }

    static boolean isDebug() {
        Boolean debug = CONFIG.getSqlDebug();
        if (Objects.isNull(debug)) {
            return Boolean.FALSE;
        }
        return debug;
    }

    static Class<?> clazzPin() {
        return CONFIG.getImplPin();
    }

    static Class<?> clazzSchema() {
        Class<Object> clazz = CONFIG.getImplSchema();
        if (Objects.isNull(clazz)) {
            clazz = JsonSchema.class;
        }
        return clazz;
    }

    static Class<?> clazzModel() {
        Class<Object> clazz = CONFIG.getImplModel();
        if (Objects.isNull(clazz)) {
            clazz = JsonModel.class;
        }
        return clazz;
    }

    static Class<?> clazzSwitcher() {
        return CONFIG.getImplSwitcher();
    }
}

