/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.acc;

import cn.vertxup.atom.domain.tables.daos.MAccDao;
import cn.vertxup.atom.domain.tables.pojos.MAcc;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.acc.Rise;
import io.vertx.tp.modular.dao.AoDao;
import io.vertx.up.atom.record.Apt;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.config.Database;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

class RiseRapid
implements Rise {
    private transient Database database;

    RiseRapid() {
    }

    @Override
    public Rise bind(Database database) {
        this.database = database;
        return this;
    }

    @Override
    public Future<Apt> fetchBatch(JsonObject criteria, DataAtom atom) {
        return Ux.thenCombine(this.inputData(criteria, atom), this.inputAcc(criteria, atom), (data, acc) -> this.combineAcc((JsonArray)data, (JsonArray)acc, atom));
    }

    private Future<Apt> combineAcc(JsonArray data, JsonArray acc, DataAtom atom) {
        Apt apt = Apt.create((JsonArray)acc, (JsonArray)data);
        ConcurrentMap<ChangeFlag, JsonArray> compared = Ao.diffPure(acc, data, atom, atom.falseOut());
        return apt.comparedAsync(compared);
    }

    private Future<JsonArray> inputData(JsonObject criteria, DataAtom atom) {
        AoDao dao = Ao.toDao(this.database, atom);
        return dao.fetchAsync(criteria).compose(records -> Ux.future((Object)Ut.toJArray((Record[])records)));
    }

    @Override
    public Future<Boolean> writeData(String key, JsonArray data, DataAtom atom) {
        return this.fetchAcc(key, atom).compose(queried -> {
            if (Objects.isNull(queried)) {
                MAcc acc = new MAcc();
                acc.setKey(UUID.randomUUID().toString());
                acc.setModelId(atom.identifier());
                acc.setModelKey(key);
                acc.setRecordJson(data.encode());
                acc.setActive(Boolean.TRUE);
                acc.setLanguage(atom.language());
                acc.setSigma(atom.sigma());
                acc.setCreatedAt(LocalDateTime.now());
                acc.setUpdatedAt(LocalDateTime.now());
                return Ux.Jooq.on(MAccDao.class).insertAsync((Object)acc);
            }
            queried.setRecordJson(data.encode());
            queried.setUpdatedAt(LocalDateTime.now());
            return Ux.Jooq.on(MAccDao.class).updateAsync(queried);
        }).compose(nil -> Ux.future((Object)Boolean.TRUE));
    }

    private Future<JsonArray> inputAcc(JsonObject criteria, DataAtom atom) {
        String modelKey = atom.key(criteria);
        return this.fetchAcc(modelKey, atom).compose(acc -> {
            if (Objects.isNull(acc)) {
                return Ux.futureA();
            }
            JsonArray data = Ut.toJArray((String)acc.getRecordJson());
            return Ux.future((Object)data);
        });
    }

    private Future<MAcc> fetchAcc(String modelKey, DataAtom atom) {
        JsonObject condition = new JsonObject();
        condition.put("modelKey", (Object)modelKey);
        condition.put("sigma", (Object)atom.sigma());
        return Ux.Jooq.on(MAccDao.class).fetchOneAsync(condition);
    }
}

