/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.dao;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.modular.dao.AoDao;
import io.vertx.tp.modular.dao.internal.UAggr;
import io.vertx.tp.modular.dao.internal.UFlush;
import io.vertx.tp.modular.dao.internal.UList;
import io.vertx.tp.modular.dao.internal.USearch;
import io.vertx.tp.modular.dao.internal.UUnique;
import io.vertx.tp.modular.jdbc.AoConnection;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.up.atom.query.Criteria;
import io.vertx.up.commune.Record;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.util.Objects;

public abstract class AbstractDao
implements AoDao {
    protected final transient AoConnection conn;
    private final transient UFlush flush = UFlush.create();
    private final transient UUnique unique = UUnique.create();
    private final transient UList list = UList.create();
    private final transient USearch search = USearch.create();
    private final transient UAggr aggr = UAggr.create();

    public AbstractDao(AoConnection conn) {
        this.conn = conn;
        ((UFlush)this.flush.on(this.conn)).on(this.sentence());
        ((UUnique)this.unique.on(this.conn)).on(this.sentence());
        ((UList)this.list.on(this.conn)).on(this.sentence());
        ((USearch)this.search.on(this.conn)).on(this.sentence());
        ((UAggr)this.aggr.on(this.conn)).on(this.sentence());
    }

    @Override
    public AoDao mount(DataAtom atom) {
        this.unique.on(atom);
        this.flush.on(atom);
        this.list.on(atom);
        this.search.on(atom);
        this.aggr.on(atom);
        return this;
    }

    @Override
    public int execute(String sql) {
        return this.conn.execute(sql);
    }

    @Override
    public Long count(Criteria criteria) {
        return (Long)Fn.getNull((Object)-1L, () -> this.aggr.count(criteria), (Object[])new Object[]{criteria});
    }

    @Override
    public Future<Long> countAsync(Criteria criteria) {
        return (Future)Fn.getNull((Object)Ux.future((Object)-1L), () -> this.aggr.countAsync(criteria), (Object[])new Object[]{criteria});
    }

    @Override
    public Boolean exist(Criteria criteria) {
        return (Boolean)Fn.getNull((Object)Boolean.FALSE, () -> this.aggr.existing(criteria), (Object[])new Object[]{criteria});
    }

    @Override
    public Future<Boolean> existAsync(Criteria criteria) {
        return (Future)Fn.getNull((Object)Ux.future((Object)Boolean.FALSE), () -> this.aggr.existingAsync(criteria), (Object[])new Object[]{criteria});
    }

    @Override
    public Boolean miss(Criteria criteria) {
        return (Boolean)Fn.getNull((Object)Boolean.FALSE, () -> this.aggr.missing(criteria), (Object[])new Object[]{criteria});
    }

    @Override
    public Future<Boolean> missAsync(Criteria criteria) {
        return (Future)Fn.getNull((Object)Ux.future((Object)Boolean.FALSE), () -> this.aggr.missingAsync(criteria), (Object[])new Object[]{criteria});
    }

    @Override
    public Future<Record> insertAsync(Record record) {
        return (Future)Fn.getNull((Object)Ux.future(), () -> this.flush.insertAsync(record), (Object[])new Object[]{record});
    }

    @Override
    public Record insert(Record record) {
        return (Record)Fn.getNull(null, () -> this.flush.insert(record), (Object[])new Object[]{record});
    }

    @Override
    public Record[] insert(Record ... records) {
        if (Objects.isNull(records)) {
            return new Record[0];
        }
        return this.flush.insert(records);
    }

    @Override
    public Future<Record[]> insertAsync(Record ... records) {
        if (Objects.isNull(records)) {
            return Ux.future((Object)new Record[0]);
        }
        return this.flush.insertAsync(records);
    }

    @Override
    public Future<Record[]> updateAsync(Record ... records) {
        if (Objects.isNull(records)) {
            return Ux.future((Object)new Record[0]);
        }
        return this.flush.updateAsync(records);
    }

    @Override
    public Record[] update(Record ... records) {
        if (Objects.isNull(records)) {
            return new Record[0];
        }
        return this.flush.update(records);
    }

    @Override
    public Future<Record> updateAsync(Record record) {
        return (Future)Fn.getNull((Object)Ux.future(), () -> this.flush.updateAsync(record), (Object[])new Object[]{record});
    }

    @Override
    public Record update(Record record) {
        return (Record)Fn.getNull(null, () -> this.flush.update(record), (Object[])new Object[]{record});
    }

    @Override
    public <ID> Record fetchById(ID id) {
        return (Record)Fn.getNull(null, () -> this.unique.fetchById(id), (Object[])new Object[]{id});
    }

    @Override
    public <ID> Future<Record> fetchByIdAsync(ID id) {
        return (Future)Fn.getNull((Object)Ux.future(), () -> this.unique.fetchByIdAsync(id), (Object[])new Object[]{id});
    }

    @Override
    public <ID> Record[] fetchById(ID ... ids) {
        if (Objects.isNull(ids)) {
            return new Record[0];
        }
        return this.list.fetchByIds(ids);
    }

    @Override
    public <ID> Future<Record[]> fetchByIdAsync(ID ... ids) {
        if (Objects.isNull(ids)) {
            return Ux.future((Object)new Record[0]);
        }
        return this.list.fetchByIdsAsync(ids);
    }

    @Override
    public Record[] fetchAll() {
        return this.list.fetchAll();
    }

    @Override
    public Future<Record[]> fetchAllAsync() {
        return this.list.fetchAllAsync();
    }

    @Override
    public Record fetchOne(Criteria criteria) {
        return (Record)Fn.getNull(null, () -> this.unique.fetchOne(criteria), (Object[])new Object[]{criteria});
    }

    @Override
    public JsonObject search(JsonObject query) {
        return (JsonObject)Fn.getNull((Object)Ux.pageData(), () -> this.search.search(query), (Object[])new Object[]{query});
    }

    @Override
    public Record[] fetch(JsonObject criteria) {
        return (Record[])Fn.getNull((Object)new Record[0], () -> this.search.query(criteria), (Object[])new Object[]{criteria});
    }

    @Override
    public Future<Record> fetchOneAsync(Criteria criteria) {
        return (Future)Fn.getNull((Object)Ux.future(), () -> this.unique.fetchOneAsync(criteria), (Object[])new Object[]{criteria});
    }

    @Override
    public Future<JsonObject> searchAsync(JsonObject query) {
        return (Future)Fn.getNull((Object)Ux.futureJ(), () -> this.search.searchAsync(query), (Object[])new Object[]{query});
    }

    @Override
    public Future<Record[]> fetchAsync(JsonObject criteria) {
        return (Future)Fn.getNull((Object)Ux.future((Object)new Record[0]), () -> this.search.queryAsync(criteria), (Object[])new Object[]{criteria});
    }

    @Override
    public Future<Boolean> deleteAsync(Record record) {
        return (Future)Fn.getNull((Object)Ux.future((Object)Boolean.FALSE), () -> this.flush.deleteAsync(record), (Object[])new Object[]{record});
    }

    @Override
    public boolean delete(Record record) {
        return (Boolean)Fn.getNull((Object)Boolean.FALSE, () -> this.flush.delete(record), (Object[])new Object[]{record});
    }

    @Override
    public Future<Boolean> deleteAsync(Record ... records) {
        if (Objects.isNull(records)) {
            return Ux.future((Object)Boolean.FALSE);
        }
        return this.flush.deleteAsync(records);
    }

    @Override
    public Boolean delete(Record ... records) {
        if (Objects.isNull(records)) {
            return Boolean.FALSE;
        }
        return this.flush.delete(records);
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }

    public abstract AoSentence sentence();
}

