/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.dao.internal;

import io.vertx.tp.atom.cv.em.EventType;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.error._417DataAtomNullException;
import io.vertx.tp.modular.dao.internal.AoBinder;
import io.vertx.tp.modular.jdbc.AoConnection;
import io.vertx.tp.modular.jooq.JQEngine;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.up.atom.query.Criteria;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import java.util.function.Function;

public abstract class AbstractUtil<T extends AoBinder>
implements AoBinder<T> {
    protected transient AoConnection connection;
    protected transient AoSentence sentence;
    protected transient DataAtom atom;
    protected transient JQEngine jooq;

    @Override
    public T on(AoSentence sentence) {
        this.sentence = sentence;
        this.jooq.bind(sentence);
        return (T)this;
    }

    @Override
    public T on(AoConnection connection) {
        this.connection = connection;
        this.jooq = JQEngine.create(connection.getDSL());
        return (T)this;
    }

    @Override
    public T on(DataAtom atom) {
        this.atom = atom;
        return (T)this;
    }

    protected DataEvent event() {
        Fn.outWeb((null == this.atom ? 1 : 0) != 0, _417DataAtomNullException.class, (Object[])new Object[]{this.getClass()});
        return DataEvent.create(this.atom, this.sentence).init(EventType.SINGLE);
    }

    protected DataEvent events() {
        Fn.outWeb((null == this.atom ? 1 : 0) != 0, _417DataAtomNullException.class, (Object[])new Object[]{this.getClass()});
        return DataEvent.create(this.atom, this.sentence).init(EventType.BATCH);
    }

    protected <ID> DataEvent irIDs(ID ... ids) {
        return this.events().keys(ids);
    }

    protected DataEvent irCond(Criteria criteria) {
        return this.event().criteria(criteria);
    }

    protected <T> T output(DataEvent event, Function<DataEvent, DataEvent> executor, boolean isArray) {
        event.consoleAll();
        DataEvent response = executor.apply(event);
        if (isArray) {
            return (T)response.dataA();
        }
        return (T)response.dataR();
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

