/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.file;

import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.file.AoFile;
import io.vertx.tp.modular.file.excel.ExAnalyzer;
import io.vertx.tp.modular.file.excel.ExModello;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ExcelReader
implements AoFile {
    private final transient String rootPath;

    public ExcelReader() {
        this(Ao.Path.PATH_EXCEL);
    }

    public ExcelReader(String rootPath) {
        Object normalized = Objects.isNull(rootPath) ? Ao.Path.PATH_EXCEL : (!rootPath.endsWith("/") ? rootPath + "/" : rootPath);
        this.rootPath = normalized;
    }

    @Override
    public Set<Model> readModels(String appName) {
        Set<String> files = this.readFiles("schema");
        Ao.infoUca(this.getClass(), "\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6587\u4ef6\uff1a{0}", String.valueOf(files.size()));
        Set<Schema> schemas = ExModello.create(files).on(appName).build();
        Ao.infoUca(this.getClass(), "\u5408\u8ba1\u6784\u9020\u4e86\u6a21\u578b\uff1a{0}", schemas.size());
        HashSet<Model> models = new HashSet<Model>();
        files.stream().map(ExAnalyzer::create).map(analyzer -> analyzer.on(appName)).map(analyzer -> analyzer.build(schemas)).forEach(models::addAll);
        return models;
    }

    @Override
    public Set<String> readServices() {
        return null;
    }

    @Override
    public Set<String> readDataFiles() {
        return this.readFiles("data");
    }

    private Set<String> readFiles(String folder) {
        String root = this.rootPath + folder;
        List files = Ut.ioFiles((String)root);
        return files.stream().filter(file -> !file.startsWith("~")).map(item -> root + "/" + item).collect(Collectors.toSet());
    }
}

