/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jdbc;

import io.vertx.tp.error._500EmptySQLException;
import io.vertx.tp.modular.jdbc.AoConnection;
import io.vertx.tp.modular.jdbc.Pool;
import io.vertx.tp.modular.sql.SqlOutput;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.up.commune.config.Database;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.sql.Connection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.RowCountQuery;

public class DataConnection
implements AoConnection {
    private final transient DataPool dbPool;
    private final transient Database database;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataConnection(Database database) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.database = database;
            this.dbPool = (DataPool)Fn.pool(Pool.POOL, (Object)database.getJdbcUrl(), () -> DataPool.create((Database)database));
        }
    }

    @Override
    public int execute(String sql) {
        Fn.outWeb((boolean)Ut.isNil((String)sql), _500EmptySQLException.class, (Object[])new Object[]{this.getClass()});
        this.getLogger().debug("[DB] \u6267\u884cSQL\uff1a{0}", new Object[]{sql});
        DSLContext context = this.getDSL();
        RowCountQuery query = context.query(sql);
        int ret = query.execute();
        return 0 <= ret ? ret : -1;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public Connection getConnection() {
        DataSource dataSource = this.dbPool.getDataSource();
        return (Connection)Fn.getJvm(dataSource::getConnection, (Object[])new Object[]{dataSource});
    }

    @Override
    public DSLContext getDSL() {
        return this.dbPool.getExecutor();
    }

    @Override
    public List<ConcurrentMap<String, Object>> select(String sql, String[] columns) {
        Result queries = this.fetch(sql);
        return SqlOutput.toMatrix((Result<Record>)queries, columns);
    }

    @Override
    public <T> List<T> select(String sql, String column) {
        Result queries = this.fetch(sql);
        return SqlOutput.toList((Result<Record>)queries, column);
    }

    private Result fetch(String sql) {
        Fn.outWeb((boolean)Ut.isNil((String)sql), _500EmptySQLException.class, (Object[])new Object[]{this.getClass()});
        this.getLogger().debug("[DB] \u6267\u884cSQL select\uff1a{0}", new Object[]{sql});
        DSLContext context = this.getDSL();
        ResultQuery query = context.resultQuery(sql);
        return query.fetch();
    }

    @Override
    public Long count(String sql) {
        Fn.outWeb((boolean)Ut.isNil((String)sql), _500EmptySQLException.class, (Object[])new Object[]{this.getClass()});
        this.getLogger().debug("[DB] \u6267\u884cSQL count\uff1a{0}", new Object[]{sql});
        DSLContext context = this.getDSL();
        ResultQuery query = context.resultQuery(sql);
        Record record = query.fetchOne();
        return (Long)record.getValue(0, Long.class);
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

