/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.modeling.element.DataRow;
import io.vertx.tp.error._417ConditionEmptyException;
import io.vertx.tp.error._417DataTransactionException;
import io.vertx.tp.error._417DataUnexpectException;
import io.vertx.tp.modular.jooq.internal.Jq;
import io.vertx.up.exception.WebException;
import io.vertx.up.fn.Actuator;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.exception.DataAccessException;

abstract class AbstractJQCrud {
    protected final transient DSLContext context;

    AbstractJQCrud(DSLContext context) {
        this.context = context;
    }

    protected <R> DataEvent write(DataEvent event, BiFunction<String, DataMatrix, R> actorFn, Predicate<R> testFn) {
        return (DataEvent)this.context.transactionResult(configuration -> this.run(event, rows -> rows.forEach(row -> row.matrixData().forEach((table, matrix) -> {
            this.ensure((String)table, (DataMatrix)matrix);
            Object expected = actorFn.apply((String)table, (DataMatrix)matrix);
            this.output(expected, testFn, () -> row.success((String)table), () -> new _417DataUnexpectException(this.getClass(), (String)table, String.valueOf(expected)));
        }))));
    }

    protected <R> Future<DataEvent> writeAsync(DataEvent input, BiFunction<String, DataMatrix, CompletionStage<R>> actorFn, Predicate<R> testFn) {
        return this.runAsync(input, event -> {
            ArrayList futures = new ArrayList();
            this.run((DataEvent)event, rows -> rows.forEach(row -> row.matrixData().forEach((table, matrix) -> {
                this.ensure((String)table, (DataMatrix)matrix);
                CompletionStage result = (CompletionStage)actorFn.apply((String)table, (DataMatrix)matrix);
                futures.add(Ux.fromAsync((CompletionStage)result).compose(expected -> {
                    this.output(expected, testFn, () -> row.success((String)table), () -> new _417DataUnexpectException(this.getClass(), (String)table, String.valueOf(expected)));
                    return Ux.future();
                }));
            })));
            return futures;
        });
    }

    protected DataEvent read(DataEvent event, BiFunction<String, DataMatrix, Record> actorFn) {
        return (DataEvent)this.context.transactionResult(configuration -> this.run(event, rows -> rows.forEach(row -> row.matrixData().forEach((table, matrix) -> {
            this.ensure((String)table, (DataMatrix)matrix);
            Record record = (Record)actorFn.apply((String)table, (DataMatrix)matrix);
            row.success((String)table, record, (Set<String>)new HashSet<String>());
        }))));
    }

    protected Future<DataEvent> readAsync(DataEvent input, BiFunction<String, DataMatrix, CompletionStage<Record>> actorFn) {
        return this.runAsync(input, event -> {
            ArrayList futures = new ArrayList();
            this.run((DataEvent)event, rows -> rows.forEach(row -> row.matrixData().forEach((table, matrix) -> {
                this.ensure((String)table, (DataMatrix)matrix);
                futures.add(Ux.fromAsync((CompletionStage)((CompletionStage)actorFn.apply((String)table, (DataMatrix)matrix))).compose(record -> {
                    row.success((String)table, (Record)record, (Set<String>)new HashSet<String>());
                    return Ux.future((Object)record);
                }));
            })));
            return futures;
        });
    }

    protected DataEvent readBatch(DataEvent event, BiFunction<String, List<DataMatrix>, Record[]> actorFn) {
        return (DataEvent)this.context.transactionResult(configuration -> this.run(event, rows -> Jq.argBatch(rows).forEach((table, values) -> {
            this.ensure((String)table, (List<DataMatrix>)values);
            Record[] records = (Record[])actorFn.apply((String)table, (List<DataMatrix>)values);
            this.output((String)table, (List<DataRow>)rows, records);
        })));
    }

    protected Future<DataEvent> readBatchAsync(DataEvent input, BiFunction<String, List<DataMatrix>, CompletionStage<Record[]>> actorFn) {
        return this.runAsync(input, event -> {
            ArrayList futures = new ArrayList();
            this.run((DataEvent)event, rows -> Jq.argBatch(rows).forEach((table, values) -> {
                this.ensure((String)table, (List<DataMatrix>)values);
                futures.add(Ux.fromAsync((CompletionStage)((CompletionStage)actorFn.apply((String)table, (List<DataMatrix>)values))).compose(records -> {
                    this.output((String)table, (List<DataRow>)rows, (Record[])records);
                    return Ux.future((Object)records);
                }));
            }));
            return futures;
        });
    }

    protected <R> Future<DataEvent> writeBatchAsync(DataEvent input, BiFunction<String, List<DataMatrix>, CompletionStage<R[]>> actorFn, Predicate<R[]> testFn) {
        return this.runAsync(input, event -> {
            ArrayList futures = new ArrayList();
            this.run((DataEvent)event, rows -> Jq.argBatch(rows).forEach((table, values) -> {
                this.ensure((String)table, (List<DataMatrix>)values);
                CompletionStage result = (CompletionStage)actorFn.apply((String)table, (List<DataMatrix>)values);
                futures.add(Ux.fromAsync((CompletionStage)result).compose(expected -> {
                    this.output(expected, testFn, () -> rows.forEach(row -> row.success((String)table)), () -> new _417DataUnexpectException(this.getClass(), (String)table, expected.toString()));
                    return Ux.future();
                }));
            }));
            return futures;
        });
    }

    protected <R> DataEvent writeBatch(DataEvent event, BiFunction<String, List<DataMatrix>, R[]> actorFn, Predicate<R[]> testFn) {
        return (DataEvent)this.context.transactionResult(configuration -> this.run(event, rows -> Jq.argBatch(rows).forEach((table, values) -> {
            this.ensure((String)table, (List<DataMatrix>)values);
            Object[] expected = (Object[])actorFn.apply((String)table, (List<DataMatrix>)values);
            this.output(expected, testFn, () -> rows.forEach(row -> row.success((String)table)), () -> new _417DataUnexpectException(this.getClass(), (String)table, expected.toString()));
        })));
    }

    private <R> Future<DataEvent> runAsync(DataEvent input, Function<DataEvent, List<Future<R>>> executor) {
        Promise promise = Promise.promise();
        this.context.transactionAsync(configuration -> {
            List futures = (List)executor.apply(input);
            Ux.thenCombineT((List)futures).onComplete(nil -> {
                if (nil.succeeded()) {
                    promise.complete((Object)input);
                } else {
                    promise.fail(nil.cause());
                }
            });
        });
        return promise.future();
    }

    private DataEvent run(DataEvent event, Consumer<List<DataRow>> consumer) {
        try {
            List<DataRow> rows = event.dataRows();
            if (null == rows || rows.isEmpty()) {
                this.logger().error("[ Ox ] \u884c\u5f15\u7528\u4e3a\u7a7a\uff0cDataRow = null\u3002", new Object[0]);
            } else {
                consumer.accept(rows);
            }
        }
        catch (DataAccessException ex) {
            this.logger().jvm((Throwable)ex);
            _417DataTransactionException error = new _417DataTransactionException(this.getClass(), ex);
            event.failure(error);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (!event.succeed().booleanValue()) {
            WebException error = event.getError();
            if (null != error) {
                throw error;
            }
            this.logger().error("[ Ox ] \u5f02\u5e38\u4e3a\u7a7a\uff0c\u4f46\u54cd\u5e94\u4e5f\u975e\u6cd5\u3002success = {0}", new Object[]{event.succeed()});
        }
        return event;
    }

    private void ensure(String table, DataMatrix matrix) {
        Fn.outWeb((boolean)matrix.getAttributes().isEmpty(), (Annal)this.logger(), _417ConditionEmptyException.class, (Object[])new Object[]{this.getClass(), table});
    }

    private void ensure(String table, List<DataMatrix> matrixes) {
        matrixes.forEach(matrix -> this.ensure(table, (DataMatrix)matrix));
    }

    private <T> void output(T expected, Predicate<T> predicate, Actuator actuator, Supplier<WebException> supplier) {
        if (Objects.isNull(predicate)) {
            actuator.execute();
        } else if (predicate.test(expected)) {
            actuator.execute();
        } else {
            throw supplier.get();
        }
    }

    private void output(String table, List<DataRow> rows, Record[] records) {
        for (int idx = 0; idx < rows.size(); ++idx) {
            DataRow row = rows.get(idx);
            if (null == row) continue;
            if (idx < records.length) {
                Record record = records[idx];
                row.success(table, record, new HashSet<String>());
                continue;
            }
            row.success(table, null, new HashSet<String>());
        }
    }

    private Annal logger() {
        return Annal.get(this.getClass());
    }
}

