/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.tp.atom.cv.em.ModelType;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.modeling.element.DataRow;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.error._417TableCounterException;
import io.vertx.tp.modular.query.Ingest;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jooq.DSLContext;
import org.jooq.Record;

abstract class AbstractJQQr {
    protected final transient DSLContext context;

    AbstractJQQr(DSLContext context) {
        this.context = context;
    }

    protected DataEvent aggr(DataEvent event, BiFunction<Set<String>, Ingest, Long> queryFn) {
        return (DataEvent)this.context.transactionResult(configuration -> {
            Ingest ingest = this.ingest(event);
            ConcurrentMap<String, DataMatrix> matrix = this.matrix(this.getClass(), event);
            Long counter = (Long)queryFn.apply(matrix.keySet(), ingest);
            event.stored(counter);
            return event;
        });
    }

    protected Future<DataEvent> aggrAsync(DataEvent input, BiFunction<Set<String>, Ingest, CompletionStage<Long>> queryFn) {
        return this.runAsync(input, event -> {
            Ingest ingest = this.ingest((DataEvent)event);
            ConcurrentMap<String, DataMatrix> matrix = this.matrix(this.getClass(), (DataEvent)event);
            return (CompletionStage)queryFn.apply(matrix.keySet(), ingest);
        }, counter -> {
            input.stored((Long)counter);
            return input;
        });
    }

    protected DataEvent qr(DataEvent event, BiFunction<Set<String>, Ingest, Record> queryFn) {
        return (DataEvent)this.context.transactionResult(configuration -> {
            Ingest ingest = this.ingest(event);
            ConcurrentMap<String, DataMatrix> matrix = this.matrix(this.getClass(), event);
            DataTpl tpl = event.getTpl();
            Set<String> projection = event.getProjection();
            Record record = (Record)queryFn.apply(matrix.keySet(), ingest);
            event.stored(this.output(matrix.keySet(), new Record[]{record}, tpl, projection));
            return event;
        });
    }

    protected Future<DataEvent> qrAsync(DataEvent input, BiFunction<Set<String>, Ingest, CompletionStage<Record>> queryFn) {
        ConcurrentMap<String, DataMatrix> matrix = this.matrix(this.getClass(), input);
        return this.runAsync(input, event -> {
            Ingest ingest = this.ingest((DataEvent)event);
            return (CompletionStage)queryFn.apply(matrix.keySet(), ingest);
        }, record -> {
            DataTpl tpl = input.getTpl();
            Set<String> projection = input.getProjection();
            input.stored(this.output(matrix.keySet(), new Record[]{record}, tpl, projection));
            return input;
        });
    }

    protected DataEvent qrBatch(DataEvent event, BiFunction<Set<String>, Ingest, Record[]> queryFn, BiFunction<Set<String>, Ingest, Long> countFn) {
        return (DataEvent)this.context.transactionResult(configuration -> {
            Ingest ingest = this.ingest(event);
            ConcurrentMap<String, DataMatrix> matrix = this.matrix(this.getClass(), event);
            DataTpl tpl = event.getTpl();
            Set<String> projection = event.getProjection();
            Record[] records = (Record[])queryFn.apply(matrix.keySet(), ingest);
            event.stored(this.output(matrix.keySet(), records, tpl, projection));
            if (Objects.nonNull(countFn)) {
                Long counter = (Long)countFn.apply(matrix.keySet(), ingest);
                event.stored(counter);
            }
            return event;
        });
    }

    protected Future<DataEvent> qrBatchAsync(DataEvent input, BiFunction<Set<String>, Ingest, CompletionStage<Record[]>> queryFn, BiFunction<Set<String>, Ingest, CompletionStage<Long>> countFn) {
        ConcurrentMap<String, DataMatrix> matrix = this.matrix(this.getClass(), input);
        Ingest ingest = this.ingest(input);
        return this.runAsync(input, event -> (CompletionStage)queryFn.apply(matrix.keySet(), ingest), records -> {
            DataTpl tpl = input.getTpl();
            Set<String> projection = input.getProjection();
            input.stored(this.output(matrix.keySet(), (Record[])records, tpl, projection));
            return input;
        }).compose(event -> {
            if (Objects.isNull(countFn)) {
                return Ux.future((Object)event);
            }
            return Ux.fromAsync((CompletionStage)((CompletionStage)countFn.apply(matrix.keySet(), ingest))).compose(counter -> {
                input.stored((Long)counter);
                return Ux.future((Object)input);
            });
        });
    }

    private <R> Future<DataEvent> runAsync(DataEvent input, Function<DataEvent, CompletionStage<R>> executor, Function<R, DataEvent> convertFn) {
        Promise promise = Promise.promise();
        this.context.transactionAsync(configuration -> {
            Future future = Ux.fromAsync((CompletionStage)((CompletionStage)executor.apply(input)));
            future.onComplete(nil -> {
                if (nil.succeeded()) {
                    promise.complete((Object)((DataEvent)convertFn.apply(nil.result())));
                } else {
                    promise.fail(nil.cause());
                }
            });
        });
        return promise.future();
    }

    private Ingest ingest(DataEvent event) {
        ModelType type = event.getType();
        Ingest ingest = Ingest.create(type);
        DataAtom atomRef = event.getTpl().atom();
        Ao.infoUca(this.getClass(), "\u67e5\u8be2\u89e3\u6790\u5668\uff1a{0}\uff0c\u64cd\u4f5c\u6a21\u578b\uff1a{1}", null == ingest ? null : ingest.getClass().getName(), atomRef.identifier());
        return ingest;
    }

    private ConcurrentMap<String, DataMatrix> matrix(Class<?> clazz, DataEvent event) {
        ModelType type = event.getType();
        DataTpl tpl = event.getTpl();
        ConcurrentMap<String, DataMatrix> matrix = tpl.matrixData();
        if (ModelType.DIRECT == type) {
            Fn.outWeb((1 != matrix.size() ? 1 : 0) != 0, _417TableCounterException.class, (Object[])new Object[]{clazz, matrix.size()});
        } else if (ModelType.JOINED == type) {
            Fn.outWeb((1 >= matrix.size() ? 1 : 0) != 0, _417TableCounterException.class, (Object[])new Object[]{clazz, matrix.size()});
        }
        return matrix;
    }

    private List<DataRow> output(Set<String> tableSet, Record[] records, DataTpl tpl, Set<String> projection) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (Record record : records) {
            DataRow row = new DataRow(tpl);
            tableSet.forEach(table -> row.success((String)table, record, projection));
            rows.add(row);
        }
        return rows;
    }

    private Annal logger() {
        return Annal.get(this.getClass());
    }
}

