/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.core.Future;
import io.vertx.tp.atom.cv.AoCache;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.jooq.JQAggregate;
import io.vertx.tp.modular.jooq.JQDelete;
import io.vertx.tp.modular.jooq.JQInsert;
import io.vertx.tp.modular.jooq.JQQuery;
import io.vertx.tp.modular.jooq.JQRead;
import io.vertx.tp.modular.jooq.JQUpdate;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.up.fn.Fn;
import org.jooq.DSLContext;

public class JQEngine {
    private final transient JQInsert insertT;
    private final transient JQDelete deleteT;
    private final transient JQQuery queryT;
    private final transient JQUpdate updateT;
    private final transient JQAggregate aggrT;
    private final transient JQRead readT;

    private JQEngine(DSLContext context) {
        boolean isSql = Ao.isDebug();
        if (isSql) {
            context.settings().setDebugInfoOnStackTrace(Boolean.TRUE);
        }
        this.insertT = new JQInsert(context);
        this.deleteT = new JQDelete(context);
        this.updateT = new JQUpdate(context);
        this.readT = new JQRead(context);
        this.aggrT = new JQAggregate(context);
        this.queryT = new JQQuery(context);
    }

    public static JQEngine create(DSLContext context) {
        return (JQEngine)Fn.poolThread(AoCache.POOL_ENGINES, () -> new JQEngine(context), (String)String.valueOf(context.hashCode()));
    }

    public JQEngine bind(AoSentence sentence) {
        this.queryT.bind(sentence);
        return this;
    }

    public DataEvent update(DataEvent event) {
        return this.updateT.update(event);
    }

    public DataEvent updateBatch(DataEvent event) {
        return this.updateT.updateBatch(event);
    }

    public DataEvent insert(DataEvent event) {
        return this.insertT.insert(event);
    }

    public DataEvent insertBatch(DataEvent events) {
        return this.insertT.insertBatch(events);
    }

    public DataEvent fetchByIds(DataEvent events) {
        return this.readT.fetchByIds(events);
    }

    public DataEvent fetchById(DataEvent event) {
        return this.readT.fetchById(event);
    }

    public DataEvent fetchOne(DataEvent event) {
        return this.queryT.fetchOne(event);
    }

    public DataEvent fetchAll(DataEvent event) {
        return this.queryT.fetchAll(event);
    }

    public DataEvent search(DataEvent event) {
        return this.queryT.search(event);
    }

    public DataEvent query(DataEvent event) {
        return this.queryT.query(event);
    }

    public DataEvent delete(DataEvent event) {
        return this.deleteT.delete(event);
    }

    public DataEvent deleteBatch(DataEvent event) {
        return this.deleteT.deleteBatch(event);
    }

    public Future<DataEvent> updateAsync(DataEvent event) {
        return this.updateT.updateAsync(event);
    }

    public Future<DataEvent> updateBatchAsync(DataEvent event) {
        return this.updateT.updateBatchAsync(event);
    }

    public Future<DataEvent> insertAsync(DataEvent event) {
        return this.insertT.insertAsync(event);
    }

    public Future<DataEvent> insertBatchAsync(DataEvent event) {
        return this.insertT.insertBatchAsync(event);
    }

    public Future<DataEvent> fetchByIdsAsync(DataEvent event) {
        return this.readT.fetchByIdsAsync(event);
    }

    public Future<DataEvent> fetchByIdAsync(DataEvent event) {
        return this.readT.fetchByIdAsync(event);
    }

    public Future<DataEvent> fetchOneAsync(DataEvent event) {
        return this.queryT.fetchOneAsync(event);
    }

    public Future<DataEvent> fetchAllAsync(DataEvent event) {
        return this.queryT.fetchAllAsync(event);
    }

    public Future<DataEvent> searchAsync(DataEvent event) {
        return this.queryT.searchAsync(event);
    }

    public Future<DataEvent> queryAsync(DataEvent event) {
        return this.queryT.queryAsync(event);
    }

    public Future<DataEvent> deleteAsync(DataEvent event) {
        return this.deleteT.deleteAsync(event);
    }

    public Future<DataEvent> deleteBatchAsync(DataEvent event) {
        return this.deleteT.deleteBatchAsync(event);
    }

    public Future<DataEvent> countAsync(DataEvent event) {
        return this.aggrT.countAsync(event);
    }

    public DataEvent count(DataEvent event) {
        return this.aggrT.count(event);
    }
}

