/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.core.Future;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.modular.jooq.AbstractJQCrud;
import io.vertx.tp.modular.jooq.internal.Jq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jooq.Batch;
import org.jooq.DSLContext;
import org.jooq.InsertReturningStep;
import org.jooq.InsertSetMoreStep;

class JQInsert
extends AbstractJQCrud {
    JQInsert(DSLContext context) {
        super(context);
    }

    DataEvent insert(DataEvent event) {
        return this.write(event, (table, matrix) -> {
            InsertReturningStep step = this.stepInsert((String)table, (DataMatrix)matrix);
            return step.execute();
        }, Ut::isPositive);
    }

    Future<DataEvent> insertAsync(DataEvent event) {
        return this.writeAsync(event, (table, matrix) -> {
            InsertReturningStep step = this.stepInsert((String)table, (DataMatrix)matrix);
            return step.executeAsync();
        }, Ut::isPositive);
    }

    DataEvent insertBatch(DataEvent event) {
        return this.writeBatch(event, (table, matrix) -> {
            Batch batch = this.prepareBatch((String)table, (List<DataMatrix>)matrix);
            ArrayList result = new ArrayList();
            Arrays.stream(batch.execute()).forEach(result::add);
            return result.toArray(new Integer[0]);
        }, Ut::isPositive);
    }

    Future<DataEvent> insertBatchAsync(DataEvent event) {
        return Ux.future((Object)this.insertBatch(event));
    }

    private Batch prepareBatch(String table, List<DataMatrix> matrices) {
        ArrayList batchOps = new ArrayList();
        matrices.stream().map(matrix -> this.stepInsert(table, (DataMatrix)matrix)).forEach(batchOps::add);
        return this.context.batch(batchOps);
    }

    private InsertReturningStep stepInsert(String table, DataMatrix matrix) {
        InsertSetMoreStep steps = (InsertSetMoreStep)this.context.insertInto(Jq.toTable(table));
        Jq.argSet(matrix, (arg_0, arg_1) -> ((InsertSetMoreStep)steps).set(arg_0, arg_1));
        return steps;
    }
}

