/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.core.Future;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.modular.jooq.AbstractJQQr;
import io.vertx.tp.modular.jooq.JQTerm;
import io.vertx.tp.modular.jooq.internal.Jq;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.tp.modular.query.Ingest;
import java.util.Set;
import org.jooq.DSLContext;
import org.jooq.SelectWhereStep;

class JQQuery
extends AbstractJQQr {
    private final transient JQTerm term;

    JQQuery(DSLContext context) {
        super(context);
        this.term = new JQTerm(context);
    }

    JQQuery bind(AoSentence sentence) {
        this.term.bind(sentence);
        return this;
    }

    DataEvent query(DataEvent events) {
        return this.qrBatch(events, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectSample(events, (Set<String>)tables, (Ingest)ingest);
            return query.fetchArray();
        }, null);
    }

    Future<DataEvent> queryAsync(DataEvent events) {
        return this.qrBatchAsync(events, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectSample(events, (Set<String>)tables, (Ingest)ingest);
            return query.fetchAsync().thenApplyAsync(Jq::toRecords);
        }, null);
    }

    DataEvent fetchOne(DataEvent event) {
        return this.qr(event, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectSample(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetchOne();
        });
    }

    Future<DataEvent> fetchOneAsync(DataEvent event) {
        return this.qrAsync(event, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectSample(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetchAsync().thenApplyAsync(Jq::toRecord);
        });
    }

    DataEvent fetchAll(DataEvent event) {
        return this.qrBatch(event, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectAll(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetchArray();
        }, null);
    }

    Future<DataEvent> fetchAllAsync(DataEvent event) {
        return this.qrBatchAsync(event, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectAll(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetchAsync().thenApplyAsync(Jq::toRecords);
        }, null);
    }

    DataEvent search(DataEvent event) {
        return this.qrBatch(event, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectComplex(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetchArray();
        }, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectSample(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetch().size();
        });
    }

    Future<DataEvent> searchAsync(DataEvent event) {
        return this.qrBatchAsync(event, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectComplex(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetchAsync().thenApplyAsync(Jq::toRecords);
        }, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectSample(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetchAsync().thenApplyAsync(result -> result.size());
        });
    }
}

