/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.modular.jooq.JQToolkit;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.tp.modular.query.Ingest;
import io.vertx.up.atom.query.Pager;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectWhereStep;
import org.jooq.Table;

class JQTerm {
    private final transient DSLContext context;
    private transient AoSentence sentence;

    JQTerm(DSLContext context) {
        this.context = context;
    }

    JQTerm bind(AoSentence sentence) {
        this.sentence = sentence;
        return this;
    }

    SelectWhereStep getSelectSample(DataEvent event, Set<String> tables, Ingest ingest) {
        ConcurrentMap<String, String> tableMap = JQToolkit.getMap(tables);
        return this.getSelectSample(event, tables, ingest, tableMap);
    }

    SelectWhereStep getSelectSample(DataEvent event, Set<String> tables, Ingest ingest, ConcurrentMap<String, String> tableMap) {
        SelectWhereStep step = this.getSelectAll(event, tables, ingest, tableMap, arg_0 -> ((DSLContext)this.context).selectFrom(arg_0));
        Condition condition = JQToolkit.getCondition(event, ingest, tableMap);
        step.where(condition);
        return step;
    }

    SelectWhereStep getSelectAll(DataEvent event, Set<String> tables, Ingest ingest) {
        return this.getSelectAll(event, tables, ingest, null, arg_0 -> ((DSLContext)this.context).selectFrom(arg_0));
    }

    private <T> T getSelectAll(DataEvent event, Set<String> tables, Ingest ingest, ConcurrentMap<String, String> inputMap, Function<Table<Record>, T> executor) {
        if (Objects.nonNull(this.sentence)) {
            ingest.bind(this.sentence);
        }
        ConcurrentMap<String, String> tableMap = Objects.isNull(inputMap) ? JQToolkit.getMap(tables) : inputMap;
        Table<Record> table = 1 == tables.size() ? ingest.onTable(event.getTpl(), tables) : ingest.onTable(event.getTpl(), tables, tableMap);
        return executor.apply(table);
    }

    SelectWhereStep getSelectComplex(DataEvent event, Set<String> tables, Ingest ingest) {
        Pager pager;
        ConcurrentMap<String, String> tableMap = JQToolkit.getMap(tables);
        SelectWhereStep step = this.getSelectSample(event, tables, ingest, tableMap);
        List<OrderField> sorters = JQToolkit.getSorter(event, ingest, tableMap);
        if (!sorters.isEmpty()) {
            step.orderBy(sorters);
        }
        if (Objects.nonNull(pager = event.getPager())) {
            step.offset(pager.getStart()).limit(pager.getSize());
        }
        return step;
    }
}

