/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.core.Future;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.modular.jooq.AbstractJQCrud;
import io.vertx.tp.modular.jooq.JQQuery;
import io.vertx.tp.modular.jooq.internal.Jq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jooq.Batch;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.UpdateSetMoreStep;

class JQUpdate
extends AbstractJQCrud {
    private final transient JQQuery query;

    JQUpdate(DSLContext context) {
        super(context);
        this.query = new JQQuery(context);
    }

    DataEvent update(DataEvent event) {
        return this.write(event, (table, matrix) -> {
            UpdateSetMoreStep step = this.stepUpdate((String)table, (DataMatrix)matrix);
            return step.execute();
        }, Ut::isPositive);
    }

    Future<DataEvent> updateAsync(DataEvent event) {
        return this.writeAsync(event, (table, matrix) -> {
            UpdateSetMoreStep step = this.stepUpdate((String)table, (DataMatrix)matrix);
            return step.executeAsync();
        }, Ut::isPositive);
    }

    DataEvent updateBatch(DataEvent event) {
        return this.writeBatch(event, (table, matrix) -> {
            Batch batch = this.prepareBatch((String)table, (List<DataMatrix>)matrix);
            ArrayList result = new ArrayList();
            Arrays.stream(batch.execute()).forEach(result::add);
            return result.toArray(new Integer[0]);
        }, Ut::isPositive);
    }

    Future<DataEvent> updateBatchAsync(DataEvent event) {
        return Ux.future((Object)this.updateBatch(event));
    }

    private Batch prepareBatch(String table, List<DataMatrix> matrices) {
        ArrayList batchOps = new ArrayList();
        matrices.stream().map(matrix -> this.stepUpdate(table, (DataMatrix)matrix)).forEach(batchOps::add);
        return this.context.batch(batchOps);
    }

    private UpdateSetMoreStep stepUpdate(String table, DataMatrix matrix) {
        UpdateSetMoreStep steps = (UpdateSetMoreStep)this.context.update(Jq.toTable(table));
        Jq.argSet(matrix, (arg_0, arg_1) -> ((UpdateSetMoreStep)steps).set(arg_0, arg_1));
        Condition condition = Jq.inWhere(matrix);
        steps.where(condition);
        return steps;
    }
}

