/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq.internal;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.error._417TableCounterException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;

class Meta {
    private static final Annal LOGGER = Annal.get(Meta.class);

    Meta() {
    }

    static Table<Record> table(String name) {
        return DSL.table((Name)DSL.name((String)name));
    }

    static Table<Record> table(String name, String alias) {
        return DSL.table((Name)DSL.name((String)name)).as(DSL.name((String)alias));
    }

    static Table<Record> natureJoin(ConcurrentMap<String, String> tableMap) {
        Iterator it = tableMap.keySet().iterator();
        Fn.outWeb((1 < tableMap.size() && !it.hasNext() ? 1 : 0) != 0, _417TableCounterException.class, (Object[])new Object[]{Meta.class, "> 1"});
        String table = (String)it.next();
        Table result = Meta.table(table, (String)tableMap.get(table));
        while (it.hasNext()) {
            table = (String)it.next();
            String alias = (String)tableMap.get(table);
            result = result.naturalJoin(Meta.table(table, alias));
        }
        return result;
    }

    static Table<Record> leftJoin(String leader, ConcurrentMap<String, String> joined, ConcurrentMap<String, String> aliasMap) {
        Table<Record> first = Meta.table(leader, (String)aliasMap.get(leader));
        Fn.outWeb((1 == aliasMap.size() && Objects.isNull(first) ? 1 : 0) != 0, _417TableCounterException.class, (Object[])new Object[]{Meta.class, "> 1"});
        if (joined.isEmpty()) {
            return first;
        }
        Iterator itJoin = joined.keySet().stream().filter(table -> !leader.equals(table)).iterator();
        ConcurrentHashMap<String, String> normalized = new ConcurrentHashMap<String, String>();
        aliasMap.keySet().forEach(table -> {
            String tableKey = (String)aliasMap.get(table);
            String tableField = (String)joined.get(table);
            normalized.put(tableKey, tableField);
        });
        String firstJoin = (String)itJoin.next();
        Table<Record> joinTable = Meta.table(firstJoin, (String)aliasMap.get(firstJoin));
        TableOnConditionStep<Record> conditionStep = Meta.joinCondition(first, joinTable, normalized);
        while (itJoin.hasNext()) {
            String nextJoin = (String)itJoin.next();
            Table<Record> nextTable = Meta.table(nextJoin, (String)aliasMap.get(nextJoin));
            conditionStep = Meta.joinCondition(conditionStep, nextTable, normalized);
        }
        return conditionStep;
    }

    private static TableOnConditionStep<Record> joinCondition(Table<Record> from, Table<Record> to, ConcurrentMap<String, String> joined) {
        String fromTable = from.getName();
        String toTable = to.getName();
        return from.leftJoin(to).on(Meta.joinCondition(fromTable, (String)joined.get(fromTable), toTable, (String)joined.get(toTable)));
    }

    private static Condition joinCondition(String fromTable, String fromField, String toTable, String toField) {
        Name fromName = DSL.name((String)fromField);
        Field from = DSL.field((String)(fromTable + "." + fromField));
        Field to = DSL.field((String)(toTable + "." + toField));
        return from.eq(to);
    }

    static Field field(String field, DataMatrix matrix) {
        String column = matrix.getColumn(field);
        Class<Object> type = matrix.getType(field);
        if (JsonArray.class == type || JsonObject.class == type) {
            type = String.class;
        }
        return DSL.field((String)column, type);
    }

    static Field field(String field, Set<DataMatrix> matrixSet, ConcurrentMap<String, String> fieldMap) {
        DataMatrix matrix = matrixSet.stream().filter(item -> item.getAttributes().contains(field)).findFirst().orElse(null);
        if (null == matrix) {
            Ao.infoSQL(LOGGER, "\u6a21\u578b\u4e2d\u65e0\u6cd5\u627e\u5230\u6761\u4ef6\u5b57\u6bb5\uff08INTERNAL\uff09\uff1a`{0}`\uff0c\u7701\u7565\u2026\u2026", field);
            return null;
        }
        String column = matrix.getColumn(field);
        Class<?> type = matrix.getType(field);
        if (null == fieldMap || fieldMap.isEmpty()) {
            return DSL.field((String)column, type);
        }
        String prefix = (String)fieldMap.get(column);
        return DSL.field((String)(prefix + "." + column), type);
    }
}

