/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.phantom;

import cn.vertxup.atom.domain.tables.pojos.MModel;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.modular.phantom.AoModeler;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ModelTool {
    private final transient String namespace;

    ModelTool(String namespace) {
        this.namespace = namespace;
    }

    Future<Set<Model>> combine(JsonArray models) {
        HashSet modelSet = new HashSet();
        Ut.itJArray((JsonArray)models).map(data -> Model.instance(this.namespace, data)).forEach(modelSet::add);
        return Ux.future(modelSet);
    }

    Future<JsonArray> startList(List<MModel> modelList) {
        ArrayList futures = new ArrayList();
        modelList.stream().map(this::execute).forEach(futures::add);
        return Ux.thenCombine(futures);
    }

    Future<JsonObject> execute(MModel model) {
        return Ux.future((Object)this.onResult(model)).compose(AoModeler.init().apply()).compose(AoModeler.attribute().apply()).compose(AoModeler.join().apply()).compose(AoModeler.entity().apply()).compose(AoModeler.scatter().apply());
    }

    private JsonObject onResult(MModel model) {
        return null == model ? new JsonObject() : (JsonObject)Ut.serializeJson((Object)model);
    }

    JsonObject onCriteria(String identifier) {
        JsonObject filters = new JsonObject();
        filters.put("namespace", (Object)this.namespace);
        filters.put("identifier", (Object)identifier);
        return filters;
    }
}

