/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.plugin;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.config.AoAttribute;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.modular.plugin.IComponent;
import io.vertx.tp.modular.plugin.INormalizer;
import io.vertx.tp.modular.plugin.IoSource;
import io.vertx.tp.modular.plugin.OComponent;
import io.vertx.tp.modular.plugin.OExpression;
import io.vertx.up.atom.Kv;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.element.JComponent;
import io.vertx.up.fn.TiConsumer;
import io.vertx.up.util.Ut;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

class IoArranger {
    IoArranger() {
    }

    static ConcurrentMap<String, JComponent> pluginIn(DataTpl tpl) {
        return IoArranger.extractPlugin(tpl, MAttribute::getInComponent, IoArranger::notAop, IComponent.class);
    }

    static ConcurrentMap<String, JComponent> pluginInBefore(DataTpl tpl) {
        return IoArranger.extractPlugin(tpl, MAttribute::getInComponent, IoArranger::isAopBefore, IComponent.class);
    }

    static ConcurrentMap<String, JComponent> pluginInAfter(DataTpl tpl) {
        return IoArranger.extractPlugin(tpl, MAttribute::getInComponent, IoArranger::isAopAfter, IComponent.class);
    }

    static ConcurrentMap<String, JComponent> pluginOut(DataTpl tpl) {
        return IoArranger.extractPlugin(tpl, MAttribute::getOutComponent, IoArranger::notAop, OComponent.class);
    }

    static ConcurrentMap<String, JComponent> pluginOutBefore(DataTpl tpl) {
        return IoArranger.extractPlugin(tpl, MAttribute::getOutComponent, IoArranger::isAopBefore, OComponent.class);
    }

    static ConcurrentMap<String, JComponent> pluginOutAfter(DataTpl tpl) {
        return IoArranger.extractPlugin(tpl, MAttribute::getOutComponent, IoArranger::isAopAfter, OComponent.class);
    }

    static ConcurrentMap<String, JComponent> pluginNormalize(DataTpl tpl) {
        return IoArranger.extractPlugin(tpl, MAttribute::getNormalize, IoArranger::notAop, INormalizer.class);
    }

    static ConcurrentMap<String, JComponent> pluginExpression(DataTpl tpl) {
        return IoArranger.extractPlugin(tpl, MAttribute::getExpression, IoArranger::notAop, OExpression.class);
    }

    private static boolean notAop(MAttribute attribute) {
        return !IoArranger.isAop(attribute);
    }

    private static boolean isAop(MAttribute attribute) {
        return IoArranger.isAopAfter(attribute) || IoArranger.isAopBefore(attribute);
    }

    private static boolean isAopBefore(MAttribute attribute) {
        String sourceField = attribute.getSourceField();
        return "BEFORE".equals(sourceField);
    }

    private static boolean isAopAfter(MAttribute attribute) {
        String sourceField = attribute.getSourceField();
        return "AFTER".equals(sourceField);
    }

    private static ConcurrentMap<String, JComponent> extractPlugin(DataTpl tpl, Function<MAttribute, String> fnComponent, Function<MAttribute, Boolean> fnFilter, Class<?> interfaceCls) {
        Model model = tpl.atom().model();
        ConcurrentHashMap<String, JComponent> pluginMap = new ConcurrentHashMap<String, JComponent>();
        Function<MAttribute, Boolean> fnSelect = Objects.isNull(fnFilter) ? attribute -> Boolean.TRUE : fnFilter;
        model.dbAttributes().stream().filter(fnSelect::apply).forEach(attribute -> {
            JComponent component;
            String componentName = (String)fnComponent.apply((MAttribute)attribute);
            Class componentCls = Ut.clazz((String)componentName, null);
            if (Objects.nonNull(componentCls) && (component = new JComponent(attribute.getName(), componentCls)).valid(interfaceCls)) {
                JsonObject config = IoArranger.componentConfig(attribute, tpl.atom(), componentCls);
                pluginMap.put(attribute.getName(), component.bind(config));
            }
        });
        return pluginMap;
    }

    private static JsonObject componentConfig(MAttribute attribute, DataAtom atom, Class<?> componentCls) {
        JsonObject pluginConfig;
        JsonObject sourceConfig = Ut.toJObject((String)attribute.getSourceConfig());
        JsonObject combine = sourceConfig.containsKey("plugin.io") ? ((pluginConfig = Ut.toJObject((Object)sourceConfig.getValue("plugin.io"))).containsKey(componentCls.getName()) ? Ut.toJObject((Object)pluginConfig.getValue(componentCls.getName())) : new JsonObject()) : new JsonObject();
        AoAttribute aoAttr = atom.attribute(attribute.getName());
        JsonObject attrJson = new JsonObject();
        attrJson.put("name", (Object)attribute.getName());
        attrJson.put("alias", (Object)attribute.getAlias());
        attrJson.put("format", (Object)aoAttr.format());
        combine.put("attribute", (Object)attrJson);
        combine.put("source", (Object)attribute.getSource());
        combine.put("sourceField", (Object)attribute.getSourceField());
        JsonObject params = new JsonObject();
        params.put("sigma", (Object)attribute.getSigma());
        combine.put("sourceParams", (Object)params);
        return combine;
    }

    private static <T extends IoSource> JsonObject sourceData(ConcurrentMap<String, JComponent> inMap, Class<?> interfaceCls) {
        ConcurrentHashMap componentMap = new ConcurrentHashMap();
        inMap.values().forEach(component -> componentMap.put(component.source(), component));
        JsonObject sourceData = new JsonObject();
        if (Objects.nonNull(interfaceCls)) {
            componentMap.values().forEach(component -> {
                IoSource componentInstance = (IoSource)component.instance(interfaceCls, new Object[0]);
                if (Objects.nonNull(componentInstance)) {
                    componentInstance.source(component.config()).forEach((arg_0, arg_1) -> ((JsonObject)sourceData).put(arg_0, arg_1));
                }
            });
        }
        return sourceData;
    }

    static void runNorm(Record[] records, ConcurrentMap<String, JComponent> inMap) {
        IoArranger.run(records, inMap, null, (processed, component, config) -> {
            INormalizer reference = (INormalizer)component.instance(INormalizer.class, new Object[0]);
            Arrays.stream(records).forEach(record -> IoArranger.run(record, component, reference::before));
        });
    }

    static void runNorm(Record record, ConcurrentMap<String, JComponent> normalizeMap) {
        IoArranger.run(record, normalizeMap, null, (processed, component, config) -> {
            INormalizer reference = (INormalizer)component.instance(INormalizer.class, new Object[0]);
            IoArranger.run(record, component, reference::before);
        });
    }

    static void runExpr(Record[] records, ConcurrentMap<String, JComponent> inMap) {
        IoArranger.run(records, inMap, null, (processed, component, config) -> {
            OExpression reference = (OExpression)component.instance(OExpression.class, new Object[0]);
            Arrays.stream(records).forEach(record -> IoArranger.run(record, component, reference::after));
        });
    }

    static void runExpr(Record record, ConcurrentMap<String, JComponent> normalizeMap) {
        IoArranger.run(record, normalizeMap, null, (processed, component, config) -> {
            OExpression reference = (OExpression)component.instance(OExpression.class, new Object[0]);
            IoArranger.run(record, component, reference::after);
        });
    }

    static void runIn(Record record, ConcurrentMap<String, JComponent> inMap) {
        IoArranger.run(record, inMap, IComponent.class, (processed, component, config) -> {
            IComponent reference = (IComponent)component.instance(IComponent.class, new Object[0]);
            IoArranger.run(record, component, kv -> reference.before((Kv<String, Object>)kv, record, (JsonObject)config));
        });
    }

    static void runIn(Record[] records, ConcurrentMap<String, JComponent> inMap) {
        IoArranger.run(records, inMap, IComponent.class, (processed, component, config) -> {
            IComponent reference = (IComponent)component.instance(IComponent.class, new Object[0]);
            Arrays.stream(records).forEach(record -> IoArranger.run(record, component, kv -> reference.before((Kv<String, Object>)kv, (Record)record, (JsonObject)config)));
        });
    }

    static void runOut(Record record, ConcurrentMap<String, JComponent> inMap) {
        IoArranger.run(record, inMap, OComponent.class, (processed, component, config) -> {
            OComponent reference = (OComponent)component.instance(OComponent.class, new Object[0]);
            IoArranger.run(record, component, kv -> reference.after((Kv<String, Object>)kv, record, (JsonObject)config));
        });
    }

    static void runOut(Record[] records, ConcurrentMap<String, JComponent> inMap) {
        IoArranger.run(records, inMap, OComponent.class, (processed, component, config) -> {
            OComponent reference = (OComponent)component.instance(OComponent.class, new Object[0]);
            Arrays.stream(records).forEach(record -> IoArranger.run(record, component, kv -> reference.after((Kv<String, Object>)kv, (Record)record, (JsonObject)config)));
        });
    }

    private static void run(Record record, JComponent component, Function<Kv<String, Object>, Object> executor) {
        String field = component.key();
        Kv kv = Kv.create((Object)field, (Object)record.get(field));
        Object processedValue = executor.apply((Kv<String, Object>)kv);
        if (Objects.nonNull(processedValue)) {
            record.attach(field, processedValue);
        }
    }

    private static <T> void run(T input, ConcurrentMap<String, JComponent> inMap, Class<?> interfaceCls, TiConsumer<T, JComponent, JsonObject> consumer) {
        if (!inMap.isEmpty()) {
            JsonObject dataMap = IoArranger.sourceData(inMap, interfaceCls);
            inMap.forEach((field, component) -> {
                JsonObject config = component.config();
                config.put("sourceData", (Object)dataMap);
                consumer.accept(input, component, (Object)config);
            });
        }
    }
}

