/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.plugin;

import io.vertx.core.Future;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.modular.plugin.IoArranger;
import io.vertx.tp.modular.plugin.IoHub;
import io.vertx.tp.modular.reference.AoRay;
import io.vertx.tp.modular.reference.RayBatch;
import io.vertx.tp.modular.reference.RaySingle;
import io.vertx.up.commune.Record;
import io.vertx.up.fn.Fn;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class IoNerve
implements IoHub {
    private static final ConcurrentMap<String, AoRay<Record>> POOL_RAY = new ConcurrentHashMap<String, AoRay<Record>>();
    private static final ConcurrentMap<String, AoRay<Record>> POOL_RAY_ASYNC = new ConcurrentHashMap<String, AoRay<Record>>();
    private final ConcurrentMap<String, AoRay<Record[]>> POOL_RAY_BATCH = new ConcurrentHashMap<String, AoRay<Record[]>>();
    private final ConcurrentMap<String, AoRay<Record[]>> POOL_RAY_BATCH_ASYNC = new ConcurrentHashMap<String, AoRay<Record[]>>();

    @Override
    public Record in(Record record, DataTpl tpl) {
        IoArranger.runIn(record, IoArranger.pluginInBefore(tpl));
        IoArranger.runIn(record, IoArranger.pluginIn(tpl));
        IoArranger.runNorm(record, IoArranger.pluginNormalize(tpl));
        IoArranger.runIn(record, IoArranger.pluginInAfter(tpl));
        return record;
    }

    @Override
    public Record[] in(Record[] records, DataTpl tpl) {
        IoArranger.runIn(records, IoArranger.pluginInBefore(tpl));
        IoArranger.runIn(records, IoArranger.pluginIn(tpl));
        IoArranger.runNorm(records, IoArranger.pluginNormalize(tpl));
        IoArranger.runIn(records, IoArranger.pluginInAfter(tpl));
        return records;
    }

    @Override
    public Record out(Record record, DataTpl tpl) {
        if (Objects.isNull(record)) {
            return null;
        }
        this.runOut(record, tpl);
        AoRay ray = (AoRay)Fn.pool(POOL_RAY, (Object)tpl.identifier(), () -> new RaySingle().on(tpl));
        return ray.doRay(record);
    }

    @Override
    public Record[] out(Record[] records, DataTpl tpl) {
        this.runOut(records, tpl);
        AoRay ray = (AoRay)Fn.pool(this.POOL_RAY_BATCH, (Object)tpl.identifier(), () -> new RayBatch().on(tpl));
        return ray.doRay(records);
    }

    @Override
    public Future<Record> outAsync(Record record, DataTpl tpl) {
        if (Objects.isNull(record)) {
            return null;
        }
        this.runOut(record, tpl);
        AoRay ray = (AoRay)Fn.pool(POOL_RAY_ASYNC, (Object)tpl.identifier(), () -> new RaySingle().on(tpl));
        return ray.doRayAsync(record);
    }

    @Override
    public Future<Record[]> outAsync(Record[] records, DataTpl tpl) {
        this.runOut(records, tpl);
        AoRay ray = (AoRay)Fn.pool(this.POOL_RAY_BATCH_ASYNC, (Object)tpl.identifier(), () -> new RayBatch().on(tpl));
        return ray.doRayAsync(records);
    }

    private void runOut(Record record, DataTpl tpl) {
        IoArranger.runOut(record, IoArranger.pluginOutBefore(tpl));
        IoArranger.runOut(record, IoArranger.pluginOut(tpl));
        IoArranger.runExpr(record, IoArranger.pluginExpression(tpl));
        IoArranger.runOut(record, IoArranger.pluginOutAfter(tpl));
    }

    private void runOut(Record[] records, DataTpl tpl) {
        IoArranger.runOut(records, IoArranger.pluginOutBefore(tpl));
        IoArranger.runOut(records, IoArranger.pluginOut(tpl));
        IoArranger.runExpr(records, IoArranger.pluginExpression(tpl));
        IoArranger.runOut(records, IoArranger.pluginOutAfter(tpl));
    }
}

