/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.query;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.jooq.internal.Jq;
import io.vertx.tp.modular.query.Ingest;
import io.vertx.tp.modular.query.QVisitor;
import io.vertx.up.atom.query.Criteria;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.atom.query.tree.QTree;
import io.vertx.up.log.Annal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;

class DirectIngest
implements Ingest {
    private static final Annal LOGGER = Annal.get(DirectIngest.class);

    DirectIngest() {
    }

    @Override
    public Condition onCondition(DataTpl tpl, Criteria criteria) {
        QTree tree = QTree.create((Criteria)criteria);
        Ao.infoSQL(LOGGER, tree.hasValue(), "\uff08Direct\u6a21\u5f0f\uff09\u67e5\u8be2\u5206\u6790\u6811\uff1a\n{0}", tree.toString());
        DataMatrix matrix = this.getMatrix(tpl);
        return QVisitor.analyze(tree, matrix);
    }

    @Override
    public List<OrderField> onOrder(DataTpl tpl, Sorter sorter) {
        ArrayList<OrderField> orders = new ArrayList<OrderField>();
        JsonObject data = sorter.toJson();
        for (String field : data.fieldNames()) {
            String columnName = tpl.column(field);
            if (!Objects.nonNull(columnName)) continue;
            boolean isAsc = data.getBoolean(field);
            Field column = DSL.field((String)columnName);
            orders.add((OrderField)(isAsc ? column.asc() : column.desc()));
        }
        Ao.infoSQL(LOGGER, 0 < orders.size(), "\uff08Direct\u6a21\u5f0f\uff09\u6392\u5e8f\u6761\u4ef6\uff1a{0}, size = {1}", data.encode(), orders.size());
        return orders;
    }

    @Override
    public Table<Record> onTable(DataTpl tpl, Set<String> tables) {
        String table = tables.iterator().next();
        return Jq.toTable(table);
    }

    private DataMatrix getMatrix(DataTpl tpl) {
        ConcurrentMap<String, DataMatrix> matrixs = tpl.matrixData();
        return (DataMatrix)matrixs.values().iterator().next();
    }
}

