/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.query;

import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.modular.jooq.internal.Jq;
import io.vertx.tp.plugin.jooq.condition.Clause;
import io.vertx.up.atom.query.tree.QBranch;
import io.vertx.up.atom.query.tree.QLeaf;
import io.vertx.up.atom.query.tree.QNode;
import io.vertx.up.atom.query.tree.QOp;
import io.vertx.up.atom.query.tree.QTree;
import io.vertx.up.atom.query.tree.QValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Condition;
import org.jooq.Field;

class QVisitor {
    QVisitor() {
    }

    static Condition analyze(QTree tree, DataMatrix matrix) {
        QNode node = tree.getData();
        HashSet<DataMatrix> set = new HashSet<DataMatrix>();
        set.add(matrix);
        return QVisitor.analyze(node, set, null);
    }

    static Condition analyze(QTree tree, Set<DataMatrix> matrix, ConcurrentMap<String, String> fieldMap) {
        QNode node = tree.getData();
        return QVisitor.analyze(node, matrix, fieldMap);
    }

    private static Condition analyze(QNode node, Set<DataMatrix> matrix, ConcurrentMap<String, String> fieldMap) {
        if (node instanceof QValue) {
            QLeaf value = (QLeaf)node;
            return QVisitor.analyze(value, matrix, fieldMap);
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        QBranch branch = (QBranch)node;
        branch.nodes().stream().map(each -> QVisitor.analyze(each, matrix, fieldMap)).filter(Objects::nonNull).forEach(conditions::add);
        return QVisitor.analyze(conditions, node.op());
    }

    private static Condition analyze(QLeaf leaf, Set<DataMatrix> matrix, ConcurrentMap<String, String> fieldMap) {
        String field = leaf.field();
        Field column = Jq.toField(field, matrix, fieldMap);
        if (Objects.isNull(column)) {
            return null;
        }
        Clause clause = Clause.get((Class)column.getType());
        return clause.where(column, column.getName(), leaf.op().value(), leaf.value());
    }

    private static Condition analyze(List<Condition> conditions, QOp op) {
        if (conditions.isEmpty()) {
            return null;
        }
        if (1 == conditions.size()) {
            return conditions.get(0);
        }
        Condition condition = conditions.get(0);
        for (int idx = 1; idx < conditions.size(); ++idx) {
            Condition target = conditions.get(idx);
            if (null == target) continue;
            condition = QOp.AND == op ? condition.and(target) : condition.or(target);
        }
        return condition;
    }
}

