/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.reference;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.reference.RResult;
import io.vertx.up.atom.Kv;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.element.JAmb;
import io.vertx.up.eon.em.DataFormat;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

class RayResult {
    RayResult() {
    }

    static Record combine(Record record, ConcurrentMap<String, JsonArray> joinData, ConcurrentMap<String, RResult> joinResult) {
        RayResult.compressData(joinData, joinResult).forEach((field, processed) -> {
            RResult result = (RResult)joinResult.get(field);
            ConcurrentMap<String, JAmb> grouped = RayResult.groupData(processed, result);
            RayResult.combine(record, field, grouped, result);
        });
        return record;
    }

    static Record[] combine(Record[] records, ConcurrentMap<String, JsonArray> joinData, ConcurrentMap<String, RResult> joinResult) {
        RayResult.compressData(joinData, joinResult).forEach((field, processed) -> {
            RResult result = (RResult)joinResult.get(field);
            ConcurrentMap<String, JAmb> grouped = RayResult.groupData(processed, result);
            Arrays.stream(records).forEach(record -> RayResult.combine(record, field, grouped, result));
        });
        return records;
    }

    private static void combine(Record record, String field, ConcurrentMap<String, JAmb> groupData, RResult result) {
        String keyRecord = RayResult.keyRecord(record, result.joined());
        JAmb amb = (JAmb)groupData.get(keyRecord);
        if (Objects.isNull(amb)) {
            DataFormat format = result.format();
            if (DataFormat.JsonArray == format) {
                record.add(field, (Object)new JsonArray());
            } else if (DataFormat.JsonObject == format) {
                record.add(field, (Object)new JsonObject());
            }
        } else if (amb.isValid().booleanValue()) {
            RayResult.combine(record, field, amb, result);
        }
    }

    private static void combine(Record record, String field, JAmb amb, RResult result) {
        DataFormat format = result.format();
        if (DataFormat.JsonArray == format) {
            JsonArray extract = (JsonArray)amb.dataT();
            record.add(field, (Object)extract);
        } else {
            JsonObject extract = (JsonObject)amb.dataT();
            if (Ut.notNil((JsonObject)extract)) {
                if (DataFormat.JsonObject == format) {
                    record.add(field, (Object)extract);
                } else {
                    String sourceField = result.sourceField();
                    Object value = extract.getValue(sourceField);
                    if (Objects.nonNull(value)) {
                        record.add(field, value);
                    }
                }
            }
        }
    }

    private static ConcurrentMap<String, JAmb> groupData(JsonArray data, RResult result) {
        ConcurrentHashMap<String, JAmb> groupedData = new ConcurrentHashMap<String, JAmb>();
        Class<?> type = result.typeData();
        if (JsonArray.class == type) {
            Ut.itJArray((JsonArray)data).forEach(json -> {
                String key = RayResult.keyReference(json, result.joined());
                if (Ut.notNil((String)key)) {
                    ((JAmb)Fn.pool((ConcurrentMap)groupedData, (Object)key, () -> new JAmb().data(new JsonArray()))).add(json);
                }
            });
        } else {
            Ut.itJArray((JsonArray)data).forEach(json -> {
                String key = RayResult.keyReference(json, result.joined());
                if (Ut.notNil((String)key)) {
                    groupedData.put(key, new JAmb().data(json));
                }
            });
        }
        return groupedData;
    }

    private static String keyReference(JsonObject item, List<Kv<String, String>> joined) {
        return RayResult.keyJoin(arg_0 -> ((JsonObject)item).getValue(arg_0), Kv::getKey, joined);
    }

    private static String keyRecord(Record record, List<Kv<String, String>> joined) {
        return RayResult.keyJoin(arg_0 -> ((Record)record).get(arg_0), Kv::getValue, joined);
    }

    private static String keyJoin(Function<String, Object> function, Function<Kv<String, String>, String> supplier, List<Kv<String, String>> joined) {
        StringBuilder key = new StringBuilder();
        joined.forEach(kv -> {
            Object value = function.apply((String)supplier.apply((Kv<String, String>)kv));
            if (Objects.nonNull(value)) {
                key.append(value);
            }
        });
        return key.toString();
    }

    private static ConcurrentMap<String, JsonArray> compressData(ConcurrentMap<String, JsonArray> joinData, ConcurrentMap<String, RResult> joinResult) {
        ConcurrentHashMap<String, JsonArray> compressed = new ConcurrentHashMap<String, JsonArray>();
        joinData.forEach((field, each) -> {
            RResult result = (RResult)joinResult.get(field);
            JsonArray dataArray = joinData.getOrDefault(field, new JsonArray());
            assert (Objects.nonNull(result)) : "Here result should not be null.";
            JsonArray processed = result.runRuler(dataArray);
            compressed.put((String)field, processed);
        });
        return compressed;
    }
}

