/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.reference;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.config.AoRule;
import io.vertx.tp.atom.modeling.reference.RDao;
import io.vertx.tp.atom.modeling.reference.RQuote;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.up.atom.Kv;
import io.vertx.up.commune.Record;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.UxPool;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

class RaySource {
    private final transient RQuote quote;

    private RaySource(RQuote quote) {
        this.quote = quote;
    }

    static RaySource create(RQuote quote) {
        return new RaySource(quote);
    }

    public ConcurrentMap<String, JsonArray> single(Record record) {
        return this.data(rule -> rule.condition(record));
    }

    public Future<ConcurrentMap<String, JsonArray>> singleAsync(Record record) {
        return this.dataAsync(rule -> rule.condition(record));
    }

    public ConcurrentMap<String, JsonArray> batch(Record[] records) {
        return this.data(rule -> rule.condition(records));
    }

    public Future<ConcurrentMap<String, JsonArray>> batchAsync(Record[] records) {
        return this.dataAsync(rule -> rule.condition(records));
    }

    private Future<ConcurrentMap<String, JsonArray>> dataAsync(Function<AoRule, JsonObject> supplier) {
        return this.ready(supplier, (fieldCodes, execMap) -> {
            ConcurrentHashMap futureMap = new ConcurrentHashMap();
            execMap.forEach((hashCode, kv) -> {
                JsonObject condition = (JsonObject)kv.getKey();
                RDao dao = (RDao)kv.getValue();
                futureMap.put(hashCode, this.dataAsync((Integer)hashCode, () -> {
                    Ao.infoUca(this.getClass(), "Async Batch condition building: {0}", condition.encode());
                    return dao.fetchByAsync(condition);
                }));
            });
            return Ux.thenCombine(futureMap).compose(queriedMap -> {
                ConcurrentHashMap data = new ConcurrentHashMap();
                queriedMap.forEach((hashCode, dataArray) -> fieldCodes.forEach((field, codeKey) -> {
                    if (Objects.equals(hashCode, codeKey)) {
                        data.put(field, dataArray);
                    }
                }));
                return Ux.future(data);
            });
        });
    }

    private Future<JsonArray> dataAsync(Integer hashCode, Supplier<Future<JsonArray>> executor) {
        UxPool pool = Ux.Pool.on((String)"zero.pool.reference");
        return pool.get((Object)hashCode).compose(queried -> {
            if (Objects.isNull(queried)) {
                return ((Future)executor.get()).compose(actual -> pool.put((Object)hashCode, actual, 300)).compose(Kv::value);
            }
            return Ux.future((Object)queried);
        });
    }

    private ConcurrentMap<String, JsonArray> data(Function<AoRule, JsonObject> supplier) {
        return this.ready(supplier, (fieldCodes, execMap) -> {
            ConcurrentHashMap data = new ConcurrentHashMap();
            execMap.forEach((hashCode, kv) -> {
                JsonObject condition = (JsonObject)kv.getKey();
                RDao dao = (RDao)kv.getValue();
                JsonArray queried = dao.fetchBy(condition);
                Ao.infoUca(this.getClass(), "Batch condition building: {0}, size = {1}", condition.encode(), String.valueOf(queried.size()));
                fieldCodes.forEach((field, codeKey) -> {
                    if (Objects.equals(hashCode, codeKey)) {
                        data.put(field, queried);
                    }
                });
            });
            return data;
        });
    }

    private <T> T ready(Function<AoRule, JsonObject> supplier, BiFunction<ConcurrentMap<String, Integer>, ConcurrentMap<Integer, Kv<JsonObject, RDao>>, T> executor) {
        ConcurrentHashMap fieldCodes = new ConcurrentHashMap();
        ConcurrentHashMap execMap = new ConcurrentHashMap();
        this.quote.rules().forEach((field, rule) -> {
            JsonObject condition = (JsonObject)supplier.apply((AoRule)rule);
            if (Objects.nonNull(condition)) {
                int hashCode = condition.hashCode();
                fieldCodes.put(field, hashCode);
                RDao dao = this.quote.dao((String)field);
                execMap.put(hashCode, Kv.create((Object)condition, (Object)dao));
            }
        });
        return executor.apply(fieldCodes, execMap);
    }
}

