/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.sql;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.modular.sql.Pool;
import io.vertx.up.commune.config.Database;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;

public class SqlTypeProvider {
    private SqlTypeProvider(Database database) {
        JsonObject schemaData = Ut.ioJObject((String)("engine/database/sql/" + database.getCategory().name() + "/schema.json"));
        JsonObject definitions = schemaData.getJsonObject("definitions");
        for (String field : definitions.fieldNames()) {
            if (!Ut.notNil((String)field) || null == definitions.getValue(field)) continue;
            Pool.DB_MAPPING.put(field, definitions.getString(field));
        }
        JsonObject typeMappings = schemaData.getJsonObject("mappings");
        for (String field : typeMappings.fieldNames()) {
            if (!Ut.notNil((String)field) || null == typeMappings.getValue(field)) continue;
            Pool.DB_TYPE_MAPPING.put(field, typeMappings.getJsonArray(field));
        }
    }

    public static SqlTypeProvider create(Database database) {
        return (SqlTypeProvider)Fn.pool(Pool.DB_TYPE_REF, (Object)database.getCategory().name(), () -> new SqlTypeProvider(database));
    }

    public String getColumnType(String key) {
        return (String)Pool.DB_MAPPING.get(key);
    }

    public JsonArray getMappingList(String key) {
        return (JsonArray)Pool.DB_TYPE_MAPPING.get(key);
    }
}

