/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.ambient;

import cn.vertxup.atom.domain.tables.daos.MAttributeDao;
import cn.vertxup.atom.domain.tables.daos.MJoinDao;
import cn.vertxup.atom.domain.tables.daos.MModelDao;
import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MJoin;
import cn.vertxup.atom.domain.tables.pojos.MModel;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.optic.ambient.AoRefine;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

class ModelRefine
implements AoRefine {
    ModelRefine() {
    }

    public Function<JsonObject, Future<JsonObject>> apply() {
        return appJson -> {
            JsonArray modelJson = appJson.getJsonArray("models");
            String name = appJson.getString("name");
            String namespace = Model.namespace(name);
            HashSet models = new HashSet();
            Ut.itJArray((JsonArray)modelJson).map(data -> Model.instance(namespace, data)).forEach(models::add);
            Ao.infoUca(this.getClass(), "3. AoRefine.model(): {0}", String.valueOf(models.size()));
            ArrayList futures = new ArrayList();
            models.stream().map(this::saveModelAsync).forEach(futures::add);
            return Ux.thenCombine(futures).compose(nil -> Ux.future((Object)appJson));
        };
    }

    private Future<JsonObject> saveModelAsync(Model model) {
        Promise promise = Promise.promise();
        WorkerExecutor executor = Ux.nativeWorker((String)("model - " + model.identifier()));
        executor.executeBlocking(pre -> {
            ArrayList<Future<JsonArray>> futures = new ArrayList<Future<JsonArray>>();
            futures.add(this.saveAttrAsync(model));
            futures.add(this.saveJoinAsync(model));
            MModel entity = model.dbModel();
            JsonObject criteria = new JsonObject();
            criteria.put("namespace", (Object)entity.getNamespace());
            criteria.put("identifier", (Object)entity.getIdentifier());
            Ao.infoUca(this.getClass(), "3. AoRefine.model(): Model `{0}`, Upsert Criteria = `{1}`", entity.getIdentifier(), criteria.encode());
            Future execute = Ux.thenCombineArray(futures).compose(nil -> Ux.Jooq.on(MModelDao.class).upsertAsync(criteria, (Object)model.dbModel())).compose(Ux::futureJ);
            execute.onSuccess(arg_0 -> ((Promise)pre).complete(arg_0));
        }, post -> promise.complete((Object)((JsonObject)post.result())));
        return promise.future();
    }

    private Future<JsonArray> saveAttrAsync(Model model) {
        Function<MAttribute, JsonObject> fnQuery = attribute -> {
            JsonObject filters = new JsonObject();
            filters.put("name", (Object)attribute.getName());
            filters.put("modelId", (Object)attribute.getModelId());
            return filters;
        };
        JsonObject criteria = new JsonObject();
        model.dbAttributes().stream().map(fnQuery).forEach(each -> criteria.put("$" + each.hashCode(), each));
        criteria.put("", (Object)Boolean.FALSE);
        UxJooq jooqAttr = Ux.Jooq.on(MAttributeDao.class);
        return jooqAttr.fetchAsync(criteria).compose(original -> {
            HashSet<String> uniqueSet = new HashSet<String>();
            uniqueSet.add("modelId");
            uniqueSet.add("name");
            ConcurrentMap compared = Ux.compare((List)original, new ArrayList<MAttribute>(model.dbAttributes()), uniqueSet);
            return Ux.future((Object)compared);
        }).compose(compared -> this.combineAsync((ConcurrentMap)compared, arg_0 -> ((UxJooq)jooqAttr).insertAsync(arg_0), arg_0 -> ((UxJooq)jooqAttr).updateAsync(arg_0)));
    }

    private Future<JsonArray> saveJoinAsync(Model model) {
        Function<MJoin, JsonObject> fnQuery = nexus -> {
            JsonObject filters = new JsonObject();
            filters.put("namespace", (Object)nexus.getNamespace());
            filters.put("model", (Object)nexus.getModel());
            return filters;
        };
        JsonObject criteria = new JsonObject();
        model.dbJoins().stream().map(fnQuery).forEach(each -> criteria.put("$" + each.hashCode(), each));
        UxJooq jooqJoin = Ux.Jooq.on(MJoinDao.class);
        return jooqJoin.fetchAsync(criteria).compose(original -> {
            HashSet<String> uniqueSet = new HashSet<String>();
            uniqueSet.add("namespace");
            uniqueSet.add("model");
            ConcurrentMap compared = Ux.compare((List)original, new ArrayList<MJoin>(model.dbJoins()), uniqueSet);
            return Ux.future((Object)compared);
        }).compose(compared -> this.combineAsync((ConcurrentMap)compared, arg_0 -> ((UxJooq)jooqJoin).insertAsync(arg_0), arg_0 -> ((UxJooq)jooqJoin).updateAsync(arg_0)));
    }

    private <T> Future<JsonArray> combineAsync(ConcurrentMap<ChangeFlag, List<T>> compared, Function<List<T>, Future<List<T>>> insertAsyncFn, Function<List<T>, Future<List<T>>> updateAsyncFn) {
        ArrayList<Future> futures = new ArrayList<Future>();
        futures.add(insertAsyncFn.apply((List)compared.get(ChangeFlag.ADD)).compose(Ux::futureA));
        futures.add(updateAsyncFn.apply((List)compared.get(ChangeFlag.UPDATE)).compose(Ux::futureA));
        return Ux.thenCombineArray(futures);
    }
}

