/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.ambient;

import cn.vertxup.atom.domain.tables.daos.MEntityDao;
import cn.vertxup.atom.domain.tables.daos.MFieldDao;
import cn.vertxup.atom.domain.tables.daos.MKeyDao;
import cn.vertxup.atom.domain.tables.pojos.MEntity;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.jdbc.Pin;
import io.vertx.tp.modular.metadata.AoBuilder;
import io.vertx.tp.optic.ambient.AoRefine;
import io.vertx.up.commune.config.Database;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

class SchemaRefine
implements AoRefine {
    SchemaRefine() {
    }

    public Function<JsonObject, Future<JsonObject>> apply() {
        return appJson -> {
            JsonArray models = appJson.getJsonArray("models");
            String name = appJson.getString("name");
            Set<Schema> schemata = this.toSchemata(models, Model.namespace(name));
            Ao.infoUca(this.getClass(), "2. AoRefine.schema(): {0}", String.valueOf(schemata.size()));
            JsonObject source = appJson.getJsonObject("source");
            this.syncDatabase(source, schemata);
            ArrayList futures = new ArrayList();
            schemata.stream().map(this::saveSchema).forEach(futures::add);
            return Ux.thenCombine(futures).compose(nil -> Ux.future((Object)appJson));
        };
    }

    private void syncDatabase(JsonObject source, Set<Schema> schemata) {
        Database database = new Database();
        database.fromJson(source);
        Ao.infoUca(this.getClass(), "Database Extraction: {0}", database.toJson());
        Pin pin = Pin.getInstance();
        AoBuilder builder = pin.getBuilder(database);
        schemata.forEach(builder::synchron);
    }

    private Set<Schema> toSchemata(JsonArray models, String namespace) {
        HashSet<Schema> schemata = new HashSet<Schema>();
        Ut.itJArray((JsonArray)models).map(data -> Model.instance(namespace, data)).map(Model::schemata).forEach(schemata::addAll);
        return schemata;
    }

    private JsonObject onCriteria(String name, MEntity entity) {
        JsonObject filters = new JsonObject();
        filters.put("name", (Object)name);
        filters.put("entityId", (Object)entity.getKey());
        return filters;
    }

    private JsonObject onCriteria(MEntity entity) {
        JsonObject filters = new JsonObject();
        filters.put("namespace", (Object)entity.getNamespace());
        filters.put("identifier", (Object)entity.getIdentifier());
        return filters;
    }

    private Future<JsonObject> saveSchemaAsync(Schema schema) {
        Promise promise = Promise.promise();
        WorkerExecutor executor = Ux.nativeWorker((String)("schema - " + schema.identifier()));
        executor.executeBlocking(pre -> pre.handle(this.saveSchema(schema)), post -> promise.complete((Object)((JsonObject)post.result())));
        return promise.future();
    }

    private Future<JsonObject> saveSchema(Schema schema) {
        MEntity updated = schema.getEntity();
        return Ux.Jooq.on(MEntityDao.class).upsertAsync(this.onCriteria(updated), (Object)updated).compose(entity -> {
            schema.relation(entity.getKey());
            ArrayList futures = new ArrayList();
            Arrays.stream(schema.getFields()).map(field -> Ux.Jooq.on(MFieldDao.class).upsertAsync(this.onCriteria(field.getName(), (MEntity)entity), field).compose(Ux::futureJ)).forEach(futures::add);
            Arrays.stream(schema.getKeys()).map(key -> Ux.Jooq.on(MKeyDao.class).upsertAsync(this.onCriteria(key.getName(), (MEntity)entity), key).compose(Ux::futureJ)).forEach(futures::add);
            return Ux.thenCombine(futures).compose(nil -> Ux.future((Object)entity)).compose(Ux::futureJ);
        });
    }
}

