/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.modeling;

import cn.vertxup.atom.domain.tables.pojos.MEntity;
import cn.vertxup.atom.domain.tables.pojos.MField;
import cn.vertxup.atom.domain.tables.pojos.MIndex;
import cn.vertxup.atom.domain.tables.pojos.MKey;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.modular.apply.AoDefault;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jooq.tools.StringUtils;

public class JsonSchema
implements Schema {
    private final transient ConcurrentMap<String, MKey> keys = new ConcurrentHashMap<String, MKey>();
    private final transient ConcurrentMap<String, MField> fields = new ConcurrentHashMap<String, MField>();
    private final transient ConcurrentMap<String, MIndex> indexes = new ConcurrentHashMap<String, MIndex>();
    private final transient String namespace;
    private transient String identifier;
    private transient MEntity entity;
    private transient String jsonFile;

    public JsonSchema(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public Set<String> getFieldNames() {
        return this.fields.values().stream().map(MField::getName).collect(Collectors.toSet());
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public String getTable() {
        return this.entity.getTableName();
    }

    @Override
    public MField getFieldByColumn(String column) {
        return this.fields.values().stream().filter(field -> StringUtils.equals((String)field.getColumnName(), (String)column)).findFirst().orElse(null);
    }

    @Override
    public MField getField(String field) {
        return (MField)this.fields.get(field);
    }

    @Override
    public Set<String> getColumnNames() {
        return this.fields.values().stream().map(MField::getColumnName).collect(Collectors.toSet());
    }

    @Override
    public List<MField> getPrimaryKeys() {
        return this.fields.values().stream().filter(MField::getIsPrimary).collect(Collectors.toList());
    }

    @Override
    public MEntity getEntity() {
        return this.entity;
    }

    @Override
    public MField[] getFields() {
        return this.fields.values().toArray(new MField[0]);
    }

    @Override
    public MKey[] getKeys() {
        return this.keys.values().toArray(new MKey[0]);
    }

    @Override
    public String file() {
        return this.jsonFile;
    }

    @Override
    public void relation(String key) {
        this.entity.setKey(key);
        this.keys.values().forEach(keyItem -> keyItem.setEntityId(key));
        this.fields.values().forEach(fieldItem -> fieldItem.setEntityId(key));
    }

    public JsonObject toJson() {
        JsonObject content = new JsonObject();
        JsonObject entity = (JsonObject)Ut.serializeJson((Object)this.entity);
        content.put("entity", (Object)entity);
        JsonArray keys = (JsonArray)Ut.serializeJson(this.keys.values());
        content.put("keys", (Object)keys);
        JsonArray fields = (JsonArray)Ut.serializeJson(this.fields.values());
        content.put("fields", (Object)fields);
        return content;
    }

    public void fromFile(String file) {
        this.jsonFile = file;
        JsonObject data = Ut.ioJObject((String)this.jsonFile);
        this.fromJson(data);
    }

    public void fromJson(JsonObject json) {
        this.keys.clear();
        this.fields.clear();
        JsonObject data = null == json ? new JsonObject() : json.copy();
        AoDefault.schema().applyJson(data);
        JsonObject entityJson = data.getJsonObject("entity");
        entityJson = null == entityJson ? new JsonObject() : entityJson.copy();
        AoDefault.entity().applyJson(entityJson);
        this.entity = (MEntity)Ut.deserialize((JsonObject)entityJson, MEntity.class);
        this.entity.setNamespace(this.namespace);
        this.identifier = this.entity.getIdentifier();
        JsonArray keys = data.getJsonArray("keys");
        Ut.itJArray((JsonArray)keys, (key, index) -> {
            AoDefault.key().mount(this.entity).applyJson((JsonObject)key);
            MKey keyObj = (MKey)Ut.deserialize((JsonObject)key, MKey.class);
            if (Ut.notNil((String)keyObj.getName())) {
                this.keys.put(keyObj.getName(), keyObj);
            }
        });
        JsonArray fields = data.getJsonArray("fields");
        Ut.itJArray((JsonArray)fields, (field, index) -> {
            AoDefault.field().mount(this.entity).applyJson((JsonObject)field);
            MField fieldObj = (MField)Ut.deserialize((JsonObject)field, MField.class);
            if (Ut.notNil((String)fieldObj.getName())) {
                this.fields.put(fieldObj.getName(), fieldObj);
            }
        });
    }

    public String toString() {
        StringBuilder content = new StringBuilder();
        content.append("-- Schema Begin ------------------------------");
        content.append("\nfile = ").append(this.jsonFile);
        content.append("\nidentifier = ").append(this.identifier);
        content.append("\nnamespace = ").append(this.namespace);
        content.append("\n\t").append(this.entity.toString());
        content.append("\nkeys :");
        this.keys.forEach((k, v) -> content.append("\n\t").append((String)k).append(" = ").append(v.toString()));
        content.append("\nfields :");
        this.fields.forEach((k, v) -> content.append("\n\t").append((String)k).append(" = ").append(v.toString()));
        content.append("\n-- Schema End --------------------------------\n");
        return content.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonSchema)) {
            return false;
        }
        JsonSchema that = (JsonSchema)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.entity.getNamespace(), that.entity.getNamespace());
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.entity.getNamespace());
    }
}

