/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.ambient;

import io.horizon.specification.typed.TJson;
import io.horizon.spi.ambient.AoRefine;
import io.horizon.spi.mixture.AoPerformer;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.file.AoFile;
import io.vertx.tp.modular.file.FileReader;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Set;
import java.util.function.Function;

class CombineRefine
implements AoRefine {
    private final transient AoFile marshal = (AoFile)Ut.singleton(FileReader.class, (Object[])new Object[0]);

    CombineRefine() {
    }

    public Function<JsonObject, Future<JsonObject>> apply() {
        return appJson -> {
            Ao.LOG.Uca.info(this.getClass(), "1. AoRefine.combine(): {0}", new Object[]{appJson.encode()});
            String name = appJson.getString("name");
            AoPerformer performer = AoPerformer.getInstance(name);
            return performer.fetchAsync().compose(storedSet -> {
                String outPath = Ut.valueString((JsonObject)appJson, (String)"output");
                Set<Model> models = this.marshal.readModels(name, outPath);
                models.stream().filter(storedSet::contains).forEach(jsonRef -> storedSet.stream().filter(jsonRef::equals).findFirst().ifPresent(stored -> this.updateRelation((Model)stored, (Model)jsonRef)));
                return Ux.future(models);
            }).compose(models -> this.onResult((JsonObject)appJson, (Set<Model>)models));
        };
    }

    private Future<JsonObject> onResult(JsonObject appJson, Set<Model> models) {
        JsonArray modelArray = new JsonArray();
        models.stream().map(TJson::toJson).map(this::onAttribute).forEach(arg_0 -> ((JsonArray)modelArray).add(arg_0));
        appJson.put("models", (Object)modelArray);
        return Ux.future((Object)appJson);
    }

    private JsonObject onAttribute(JsonObject model) {
        model.put("attributes", (Object)model.getJsonArray("attributes"));
        return model;
    }

    private void updateRelation(Model stored, Model json) {
        if (!stored.dbModel().getKey().equals(json.dbModel().getKey())) {
            json.connect(stored.dbModel().getKey());
        }
        Set<Schema> storedSchemata = stored.schema();
        Set<Schema> jsonSchemata = json.schema();
        jsonSchemata.stream().filter(storedSchemata::contains).forEach(jsonRef -> storedSchemata.stream().filter(jsonRef::equals).findFirst().filter(storedRef -> !storedRef.getEntity().getKey().equals(jsonRef.getEntity().getKey())).ifPresent(storedRef -> jsonRef.connect(storedRef.getEntity().getKey())));
    }
}

