/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.mixture;

import cn.vertxup.atom.domain.tables.daos.MModelDao;
import cn.vertxup.atom.domain.tables.pojos.MModel;
import io.horizon.spi.mixture.AoPerformer;
import io.horizon.uca.cache.Cc;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.phantom.AoModeler;
import io.vertx.up.exception.web._404ModelNotFoundException;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModelPerformer
implements AoPerformer {
    private static final Cc<String, ModelInternal> CC_TOOL = Cc.open();
    private final transient String appName;
    private final transient ModelInternal tool;

    ModelPerformer(String appName) {
        this.appName = appName;
        this.tool = (ModelInternal)CC_TOOL.pick(() -> new ModelInternal(this.appName), (Object)this.appName);
    }

    public Future<Model> fetchAsync(String identifier) {
        return Ux.Jooq.on(MModelDao.class).fetchOneAsync(this.tool.onCriteria(identifier)).compose(this.tool::execute).compose(item -> Ux.future((Object)Ao.toModel(this.appName, item)));
    }

    public Model fetch(String identifier) {
        MModel model = (MModel)Ux.Jooq.on(MModelDao.class).fetchOne(this.tool.onCriteria(identifier));
        String namespace = Ao.toNS(this.appName);
        Fn.outWeb((null == model ? 1 : 0) != 0, _404ModelNotFoundException.class, (Object[])new Object[]{this.getClass(), namespace, identifier});
        JsonObject json = (JsonObject)Ut.serializeJson((Object)model);
        json = AoModeler.init().executor(json);
        json = AoModeler.attribute().executor(json);
        json = AoModeler.join().executor(json);
        json = AoModeler.entity().executor(json);
        json = AoModeler.scatter().executor(json);
        return Ao.toModel(this.appName, json);
    }

    @Override
    public Future<Set<Model>> fetchAsync() {
        String namespace = Ao.toNS(this.appName);
        return Ux.Jooq.on(MModelDao.class).fetchAsync("namespace", (Object)namespace).compose(this.tool::startList).compose(this.tool::combine);
    }

    private static class ModelInternal {
        private final transient String appName;

        private ModelInternal(String appName) {
            this.appName = appName;
        }

        private Future<Set<Model>> combine(JsonArray models) {
            HashSet modelSet = new HashSet();
            Ut.itJArray((JsonArray)models).map(data -> Ao.toModel(this.appName, data)).forEach(modelSet::add);
            return Ux.future(modelSet);
        }

        private Future<JsonArray> startList(List<MModel> modelList) {
            ArrayList futures = new ArrayList();
            modelList.stream().map(this::execute).forEach(futures::add);
            return Fn.combineA(futures);
        }

        private Future<JsonObject> execute(MModel model) {
            return Ux.future((Object)this.onResult(model)).compose(AoModeler.init().apply()).compose(AoModeler.attribute().apply()).compose(AoModeler.join().apply()).compose(AoModeler.entity().apply()).compose(AoModeler.scatter().apply());
        }

        private JsonObject onResult(MModel model) {
            return null == model ? new JsonObject() : (JsonObject)Ut.serializeJson((Object)model);
        }

        private JsonObject onCriteria(String identifier) {
            String namespace = Ao.toNS(this.appName);
            JsonObject filters = new JsonObject();
            filters.put("namespace", (Object)namespace);
            filters.put("identifier", (Object)identifier);
            return filters;
        }
    }
}

