/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.modeler;

import io.horizon.specification.modeler.HDao;
import io.horizon.spi.modeler.Atom;
import io.modello.specification.HRecord;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;

public class AtomAction
implements Atom {
    public Future<JsonObject> createAsync(String identifier, JsonObject data) {
        HRecord record = Ao.toRecord(identifier, data);
        HDao dao = Ao.toDao(identifier);
        return dao.insertAsync(record).compose(Ux::futureJ).compose(inserted -> Ux.futureN((JsonObject)data, null, (JsonObject)inserted));
    }

    public Future<JsonObject> updateAsync(String identifier, String key, JsonObject data) {
        return this.fetchRecord(identifier, key).compose(queried -> {
            if (Objects.isNull(queried)) {
                return Ux.futureJ();
            }
            JsonObject original = queried.toJson();
            HDao dao = Ao.toDao(identifier);
            queried.set(data);
            return dao.updateAsync(queried).compose(Ux::futureJ).compose(updated -> Ux.futureN((JsonObject)data, (JsonObject)original, (JsonObject)updated));
        });
    }

    public Future<JsonObject> fetchAsync(String identifier, String key) {
        return this.fetchRecord(identifier, key).compose(Ux::futureJ);
    }

    private Future<HRecord> fetchRecord(String identifier, String key) {
        Objects.requireNonNull(key);
        HDao dao = Ao.toDao(identifier);
        return dao.fetchByIdAsync((Object)key);
    }

    public Future<JsonArray> createAsync(String identifier, JsonArray data) {
        HRecord[] record = Ao.toRecord(identifier, data);
        HDao dao = Ao.toDao(identifier);
        return dao.insertAsync(record).compose(Ux::futureA).compose(inserted -> Ux.futureN((JsonArray)data, (JsonArray)inserted));
    }

    public Future<JsonArray> updateAsync(String identifier, Set<String> keys, JsonArray data) {
        return this.fetchRecord(identifier, keys).compose(records -> {
            JsonArray original = Ut.toJArray((HRecord[])records);
            HRecord[] recordList = Ux.updateR((HRecord[])records, (JsonArray)data);
            HDao dao = Ao.toDao(identifier);
            return dao.updateAsync(recordList).compose(Ux::futureA).compose(updated -> Ux.futureN((JsonArray)original, (JsonArray)updated));
        });
    }

    public Future<JsonArray> fetchAsync(String identifier, Set<String> keys) {
        return this.fetchRecord(identifier, keys).compose(Ux::futureA);
    }

    private Future<HRecord[]> fetchRecord(String identifier, Set<String> key) {
        Objects.requireNonNull(key);
        HDao dao = Ao.toDao(identifier);
        return dao.fetchByIdAsync((Object[])key.toArray(new String[0]));
    }
}

