/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MField;
import cn.vertxup.atom.domain.tables.pojos.MJoin;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.modeling.element.DataKey;
import io.vertx.tp.error._417RelatedFieldMissingException;
import io.vertx.tp.error._417RelatedSchemaMissingException;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

class Bridge {
    Bridge() {
    }

    static void connect(Model model, Function<Schema, BiConsumer<MField, MAttribute>> consumer) {
        Ut.itCollection(model.schema(), nil -> model.dbAttributes(), (schema, attribute) -> Arrays.asList(schema.getFields()).forEach(field -> {
            if (Objects.isNull(attribute.getSourceField())) {
                if (field.getName().equals(attribute.getName())) {
                    ((BiConsumer)consumer.apply((Schema)schema)).accept(field, attribute);
                }
            } else if (field.getName().equals(attribute.getSourceField())) {
                ((BiConsumer)consumer.apply((Schema)schema)).accept(field, attribute);
            }
        }), (schema, attribute) -> attribute.getSource().equals(schema.identifier()));
        model.schema().forEach(schema -> schema.getPrimaryKeys().forEach(field -> ((BiConsumer)consumer.apply((Schema)schema)).accept(field, Bridge.toAttribute(schema, field))));
        model.dbJoins().forEach(join -> {
            String fieldKey;
            MField field;
            String identifier = join.getEntity();
            Schema schema = model.schema(identifier);
            if (null != schema && null != (field = schema.getField(fieldKey = join.getEntityKey())) && !field.getIsPrimary().booleanValue()) {
                ((BiConsumer)consumer.apply(schema)).accept(field, Bridge.toAttribute(schema, field));
            }
        });
    }

    private static MAttribute toAttribute(Schema schema, MField field, String name) {
        MAttribute attribute = new MAttribute();
        attribute.setName(name);
        attribute.setSource(schema.identifier());
        attribute.setSourceField(field.getName());
        return attribute;
    }

    private static MAttribute toAttribute(Schema schema, MField field) {
        return Bridge.toAttribute(schema, field, field.getName());
    }

    static void join(Model model, Function<Schema, BiConsumer<MField, MAttribute>> consumer) {
        Set<MJoin> joins = model.dbJoins();
        DataKey key = model.key();
        joins.forEach(join -> {
            Schema schema = model.schema(join.getEntity());
            String unique = model.namespace() + "-" + model.identifier();
            Fn.outWeb((null == schema ? 1 : 0) != 0, _417RelatedSchemaMissingException.class, (Object[])new Object[]{Bridge.class, join.getEntity(), key.getUnique()});
            MField field = schema.getField(join.getEntityKey());
            Fn.outWeb((null == field ? 1 : 0) != 0, _417RelatedFieldMissingException.class, (Object[])new Object[]{Bridge.class, join.getEntityKey(), join.getEntity(), key.getUnique()});
            MAttribute virtual = Bridge.toAttribute(schema, field, "pk." + schema.identifier() + "." + field.getName());
            ((BiConsumer)consumer.apply(schema)).accept(field, virtual);
        });
    }
}

