/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.refine;

import io.horizon.exception.internal.EmptyIoException;
import io.horizon.specification.app.HApp;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.init.AoPin;
import io.vertx.tp.atom.modeling.builtin.DataModel;
import io.vertx.tp.atom.modeling.builtin.DataSchema;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.util.Objects;

class AoStore {
    private static final String PATH_EXCEL = "runtime/excel/";
    private static final String PATH_JSON = "runtime/json/";
    private static final String PATH_ADJUSTER = "runtime/adjuster/config.json";
    private static final String PATH_MODELING = "runtime/adjuster/modeling";

    AoStore() {
    }

    static String namespace(String appName) {
        String prefix = AoPin.getConfig().getNamespace();
        if (Ut.isNil((String)prefix)) {
            return HApp.ns((String)appName);
        }
        return MessageFormat.format(prefix, appName);
    }

    static String defineExcel() {
        String excel = AoPin.getConfig().getDefineExcel();
        return Ut.isNil((String)excel) ? PATH_EXCEL : excel;
    }

    static String defineJson() {
        String json = AoPin.getConfig().getDefineJson();
        return Ut.isNil((String)json) ? PATH_JSON : json;
    }

    static JsonObject configAdjuster() {
        String adjuster = AoPin.getConfig().getConfigAdjuster();
        if (Ut.isNil((String)adjuster)) {
            adjuster = PATH_ADJUSTER;
        }
        if (Ut.ioExist((String)adjuster)) {
            return Ut.ioJObject((String)adjuster);
        }
        return new JsonObject();
    }

    static JsonObject configModeling(String filename) {
        String modeling = AoPin.getConfig().getConfigModeling();
        if (Ut.isNil((String)modeling)) {
            modeling = PATH_MODELING;
        }
        String name = modeling.endsWith("/") ? modeling + filename + ".json" : modeling + "/" + filename + ".json";
        try {
            return Ut.ioJObject((String)name);
        }
        catch (EmptyIoException ex) {
            return new JsonObject();
        }
    }

    static boolean isDebug() {
        Boolean debug = AoPin.getConfig().getSqlDebug();
        if (Objects.isNull(debug)) {
            return Boolean.FALSE;
        }
        return debug;
    }

    static Class<?> clazzPin() {
        return AoPin.getConfig().getImplPin();
    }

    static Class<?> clazzSchema() {
        Class<Object> clazz = AoPin.getConfig().getImplSchema();
        if (Objects.isNull(clazz)) {
            clazz = DataSchema.class;
        }
        return clazz;
    }

    static Class<?> clazzModel() {
        Class<Object> clazz = AoPin.getConfig().getImplModel();
        if (Objects.isNull(clazz)) {
            clazz = DataModel.class;
        }
        return clazz;
    }

    static Class<?> clazzSwitcher() {
        return AoPin.getConfig().getImplSwitcher();
    }
}

