/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.dao;

import io.horizon.specification.modeler.HAtom;
import io.horizon.specification.modeler.HDao;
import io.horizon.uca.log.Annal;
import io.modello.specification.HRecord;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.modular.dao.internal.UAggr;
import io.vertx.tp.modular.dao.internal.UFlush;
import io.vertx.tp.modular.dao.internal.UList;
import io.vertx.tp.modular.dao.internal.USearch;
import io.vertx.tp.modular.dao.internal.UUnique;
import io.vertx.tp.modular.jdbc.AoConnection;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.up.atom.query.Criteria;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import java.util.Objects;

public abstract class AbstractDao
implements HDao {
    protected final transient AoConnection conn;
    private final transient UFlush flush = UFlush.create();
    private final transient UUnique unique = UUnique.create();
    private final transient UList list = UList.create();
    private final transient USearch search = USearch.create();
    private final transient UAggr aggr = UAggr.create();

    public AbstractDao(AoConnection conn) {
        this.conn = conn;
        ((UFlush)this.flush.on(this.conn)).on(this.sentence());
        ((UUnique)this.unique.on(this.conn)).on(this.sentence());
        ((UList)this.list.on(this.conn)).on(this.sentence());
        ((USearch)this.search.on(this.conn)).on(this.sentence());
        ((UAggr)this.aggr.on(this.conn)).on(this.sentence());
    }

    public HDao mount(HAtom atom) {
        this.unique.on(atom);
        this.flush.on(atom);
        this.list.on(atom);
        this.search.on(atom);
        this.aggr.on(atom);
        return this;
    }

    public int execute(String sql) {
        return this.conn.execute(sql);
    }

    public Long count(Criteria criteria) {
        return (Long)Fn.runOr((Object)-1L, () -> this.aggr.count(criteria), (Object[])new Object[]{criteria});
    }

    public Future<Long> countAsync(Criteria criteria) {
        return Ux.future((Object)this.count(criteria));
    }

    public Long count(JsonObject criteria) {
        return this.count(Criteria.create((JsonObject)criteria));
    }

    public Future<Long> countAsync(JsonObject criteria) {
        return this.countAsync(Criteria.create((JsonObject)criteria));
    }

    public Boolean exist(Criteria criteria) {
        return (Boolean)Fn.runOr((Object)Boolean.FALSE, () -> this.aggr.existing(criteria), (Object[])new Object[]{criteria});
    }

    public Future<Boolean> existAsync(Criteria criteria) {
        return Ux.future((Object)this.exist(criteria));
    }

    public Boolean miss(Criteria criteria) {
        return (Boolean)Fn.runOr((Object)Boolean.FALSE, () -> this.aggr.missing(criteria), (Object[])new Object[]{criteria});
    }

    public Future<Boolean> missAsync(Criteria criteria) {
        return Ux.future((Object)this.miss(criteria));
    }

    public Future<Boolean> existAsync(JsonObject criteria) {
        return this.existAsync(Criteria.create((JsonObject)criteria));
    }

    public Boolean exist(JsonObject criteria) {
        return this.exist(Criteria.create((JsonObject)criteria));
    }

    public Future<Boolean> missAsync(JsonObject criteria) {
        return this.missAsync(Criteria.create((JsonObject)criteria));
    }

    public Boolean miss(JsonObject criteria) {
        return this.miss(Criteria.create((JsonObject)criteria));
    }

    public Future<HRecord> insertAsync(HRecord record) {
        return Ux.future((Object)this.insert(record));
    }

    public HRecord insert(HRecord record) {
        return (HRecord)Fn.runOr(null, () -> this.flush.insert(record), (Object[])new Object[]{record});
    }

    public HRecord[] insert(HRecord ... records) {
        if (Objects.isNull(records)) {
            return new HRecord[0];
        }
        return this.flush.insert(records);
    }

    public Future<HRecord[]> insertAsync(HRecord ... records) {
        return Ux.future((Object)this.insert(records));
    }

    public Future<HRecord[]> updateAsync(HRecord ... records) {
        return Ux.future((Object)this.update(records));
    }

    public HRecord[] update(HRecord ... records) {
        if (Objects.isNull(records)) {
            return new HRecord[0];
        }
        return this.flush.update(records);
    }

    public Future<HRecord> updateAsync(HRecord record) {
        return Ux.future((Object)this.update(record));
    }

    public HRecord update(HRecord record) {
        return (HRecord)Fn.runOr(null, () -> this.flush.update(record), (Object[])new Object[]{record});
    }

    public <ID> HRecord fetchById(ID id) {
        return (HRecord)Fn.runOr(null, () -> this.unique.fetchById(id), (Object[])new Object[]{id});
    }

    public <ID> Future<HRecord> fetchByIdAsync(ID id) {
        return Ux.future((Object)this.fetchById(id));
    }

    public <ID> HRecord[] fetchById(ID ... ids) {
        if (Objects.isNull(ids)) {
            return new HRecord[0];
        }
        return this.list.fetchByIds(ids);
    }

    public <ID> Future<HRecord[]> fetchByIdAsync(ID ... ids) {
        return Ux.future((Object)this.fetchById(ids));
    }

    public HRecord[] fetchAll() {
        return this.list.fetchAll();
    }

    public Future<HRecord[]> fetchAllAsync() {
        return Ux.future((Object)this.fetchAll());
    }

    public HRecord fetchOne(Criteria criteria) {
        return (HRecord)Fn.runOr(null, () -> this.unique.fetchOne(criteria), (Object[])new Object[]{criteria});
    }

    public Future<HRecord> fetchOneAsync(Criteria criteria) {
        return Ux.future((Object)this.fetchOne(criteria));
    }

    public Future<HRecord> fetchOneAsync(JsonObject criteria) {
        return this.fetchOneAsync(Criteria.create((JsonObject)criteria));
    }

    public HRecord fetchOne(JsonObject criteria) {
        return this.fetchOne(Criteria.create((JsonObject)criteria));
    }

    public JsonObject search(JsonObject query) {
        return (JsonObject)Fn.runOr((Object)Ux.pageData(), () -> this.search.search(query), (Object[])new Object[]{query});
    }

    public HRecord[] fetch(JsonObject criteria) {
        return (HRecord[])Fn.runOr((Object)new HRecord[0], () -> this.search.query(criteria), (Object[])new Object[]{criteria});
    }

    public Future<JsonObject> searchAsync(JsonObject query) {
        return Ux.future((Object)this.search(query));
    }

    public Future<HRecord[]> fetchAsync(JsonObject criteria) {
        return Ux.future((Object)this.fetch(criteria));
    }

    public Future<Boolean> deleteAsync(HRecord record) {
        return Ux.future((Object)this.delete(record));
    }

    public boolean delete(HRecord record) {
        return (Boolean)Fn.runOr((Object)Boolean.FALSE, () -> this.flush.delete(record), (Object[])new Object[]{record});
    }

    public Future<Boolean> deleteAsync(HRecord ... records) {
        return Ux.future((Object)this.delete(records));
    }

    public Boolean delete(HRecord ... records) {
        if (Objects.isNull(records)) {
            return Boolean.FALSE;
        }
        return this.flush.delete(records);
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }

    public abstract AoSentence sentence();
}

