/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.file.excel;

import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class ExIn {
    ExIn() {
    }

    static Set<ExRecord> record(Set<ExTable> tables, String tableName) {
        return tables.stream().filter(table -> tableName.equals(table.getName())).flatMap(table -> table.get().stream()).collect(Collectors.toSet());
    }

    static Set<ExRecord> searchEntity(Set<ExRecord> records, ExRecord record) {
        String key = (String)record.get("key");
        return records.stream().filter(each -> key.equals(each.get("entityId"))).collect(Collectors.toSet());
    }

    static Set<ExRecord> join(Set<ExRecord> records, ExRecord record) {
        String identifier = (String)record.get("identifier");
        String namespace = (String)record.get("namespace");
        if (Ut.isNil((String)namespace)) {
            Ao.LOG.Atom.warn(ExIn.class, "\u6570\u636e\u8bb0\u5f55\u4e2d\u7f3a\u4e4f\u540d\u7a7a\u95f4: {0}", new Object[]{namespace});
        }
        return records.stream().filter(each -> identifier.equals(each.get("model"))).filter(each -> namespace.equals(each.get("namespace"))).collect(Collectors.toSet());
    }

    static Set<ExRecord> searchModel(Set<ExRecord> records, ExRecord record) {
        String key = (String)record.get("key");
        return records.stream().filter(each -> key.equals(each.get("modelId"))).collect(Collectors.toSet());
    }

    static Set<ExRecord> schemata(Set<ExRecord> records, Set<ExRecord> joins) {
        HashSet<ExRecord> schemaSet = new HashSet<ExRecord>();
        joins.forEach(join -> {
            String namespace = (String)join.get("namespace");
            String identifier = (String)join.get("entity");
            ExRecord record = records.stream().filter(each -> namespace.equals(each.get("namespace"))).filter(each -> identifier.equals(each.get("identifier"))).findFirst().orElse(null);
            if (Objects.nonNull(record)) {
                schemaSet.add(record);
            }
        });
        return schemaSet;
    }
}

