/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.file.excel;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.file.excel.ExIn;
import io.vertx.tp.modular.file.excel.ExOut;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.ExcelInfix;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.up.uca.log.DevEnv;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExModello {
    private static final ExcelClient CLIENT = ExcelInfix.getClient();
    private final transient ConcurrentMap<String, Set<ExRecord>> recordMap = new ConcurrentHashMap<String, Set<ExRecord>>();
    private transient String appName;

    private ExModello(Set<String> files) {
        files.forEach(file -> {
            block2: {
                try {
                    Set tables = CLIENT.ingest(file);
                    this.initMap(tables);
                }
                catch (Throwable ex) {
                    if (!DevEnv.devJvmStack()) break block2;
                    ex.printStackTrace();
                }
            }
        });
    }

    public static ExModello create(Set<String> files) {
        return new ExModello(files);
    }

    public ExModello on(String appName) {
        this.appName = appName;
        return this;
    }

    public Set<Schema> build() {
        HashSet<Schema> schemaSet = new HashSet<Schema>();
        Set<ExRecord> entities = this.get("M_ENTITY");
        entities.forEach(entity -> {
            Set<ExRecord> fields = ExIn.searchEntity(this.get("M_FIELD"), entity);
            Set<ExRecord> keys = ExIn.searchEntity(this.get("M_KEY"), entity);
            Set<ExRecord> indexes = ExIn.searchEntity(this.get("M_INDEX"), entity);
            JsonObject schemaJson = ExOut.toSchema(entity, fields, keys, indexes);
            schemaSet.add(Ao.toSchema(this.appName, schemaJson));
        });
        return schemaSet;
    }

    private Set<ExRecord> get(String key) {
        return this.recordMap.getOrDefault(key, new HashSet());
    }

    private void initMap(final Set<ExTable> tables) {
        ArrayList<String> from = new ArrayList<String>(){
            {
                this.add("M_ENTITY");
                this.add("M_FIELD");
                this.add("M_KEY");
                this.add("M_INDEX");
            }
        };
        ArrayList<Set<ExRecord>> to = new ArrayList<Set<ExRecord>>(){
            {
                this.add(ExIn.record(tables, "M_ENTITY"));
                this.add(ExIn.record(tables, "M_FIELD"));
                this.add(ExIn.record(tables, "M_KEY"));
                this.add(ExIn.record(tables, "M_INDEX"));
            }
        };
        Ut.elementZip((List)from, (List)to).forEach((key, records) -> {
            if (this.recordMap.containsKey(key)) {
                ((Set)this.recordMap.get(key)).addAll(records);
            } else {
                this.recordMap.put((String)key, (Set<ExRecord>)records);
            }
        });
    }
}

