/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.io;

import io.horizon.uca.log.Annal;
import io.vertx.tp.atom.modeling.element.DataRow;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.modular.io.AoIo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;

public abstract class AbstractIo
implements AoIo {
    private final transient List<DataRow> rows = new ArrayList<DataRow>();
    private final transient Set<Object> rowKeys = new HashSet<Object>();
    private transient DataTpl tpl;

    @Override
    public AoIo on(DataTpl tpl) {
        this.tpl = tpl;
        return this;
    }

    @Override
    public AoIo on(List<DataRow> input) {
        this.clearRows();
        input.forEach(this::addRow);
        return this;
    }

    @Override
    public List<DataRow> getRows() {
        return this.rows;
    }

    @Override
    public boolean clearRows() {
        this.rows.clear();
        this.rowKeys.clear();
        return true;
    }

    @Override
    public AoIo uuid() {
        List<DataRow> rows = this.getRows();
        rows.stream().filter(row -> Objects.isNull(row.getId())).forEach(row -> row.setKey(UUID.randomUUID()));
        return this;
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }

    DataRow newRow() {
        return new DataRow(this.tpl);
    }

    DataTpl tpl() {
        return this.tpl;
    }

    private void saveRow(DataRow row) {
        Object id = row.getId();
        if (Objects.isNull(id)) {
            this.addRow(row);
        } else if (!this.rowKeys.contains(row.getId())) {
            this.addRow(row);
        }
    }

    private void addRow(DataRow row) {
        this.rowKeys.add(row.getId());
        this.rows.add(row);
    }

    protected AoIo saveRows(Supplier<List<DataRow>> supplier) {
        List<DataRow> rows = supplier.get();
        rows.forEach(this::saveRow);
        this.getLogger().debug("[Io] \u6570\u636e\u884c\u6570\u91cf\uff1a{0}", new Object[]{String.valueOf(this.rows.size())});
        return this;
    }

    protected AoIo saveRow(Supplier<DataRow> supplier) {
        this.saveRow(supplier.get());
        this.getLogger().debug("[Io] \u6570\u636e\u884c\u6570\u91cf\uff1a{0}", new Object[]{String.valueOf(this.rows.size())});
        return this;
    }
}

