/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.horizon.exception.WebException;
import io.horizon.fn.Actuator;
import io.horizon.specification.uca.HLogger;
import io.horizon.uca.log.Annal;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.modeling.element.DataRow;
import io.vertx.tp.error._417ConditionEmptyException;
import io.vertx.tp.error._417DataTransactionException;
import io.vertx.tp.error._417DataUnexpectException;
import io.vertx.tp.modular.jooq.internal.Jq;
import io.vertx.up.fn.Fn;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.exception.DataAccessException;

abstract class AbstractJQCrud {
    protected final transient DSLContext context;

    AbstractJQCrud(DSLContext context) {
        this.context = context;
    }

    protected <R> DataEvent write(DataEvent event, BiFunction<String, DataMatrix, R> actorFn, Predicate<R> testFn) {
        return (DataEvent)this.context.transactionResult(configuration -> this.run(event, rows -> rows.forEach(row -> row.matrixData().forEach((table, matrix) -> {
            this.ensure((String)table, (DataMatrix)matrix);
            Object expected = actorFn.apply((String)table, (DataMatrix)matrix);
            this.output(expected, testFn, () -> row.success((String)table), () -> new _417DataUnexpectException(this.getClass(), (String)table, String.valueOf(expected)));
        }))));
    }

    protected DataEvent read(DataEvent event, BiFunction<String, DataMatrix, Record> actorFn) {
        return (DataEvent)this.context.transactionResult(configuration -> this.run(event, rows -> rows.forEach(row -> row.matrixData().forEach((table, matrix) -> {
            this.ensure((String)table, (DataMatrix)matrix);
            Record record = (Record)actorFn.apply((String)table, (DataMatrix)matrix);
            row.success((String)table, record, (Set<String>)new HashSet<String>());
        }))));
    }

    protected DataEvent readBatch(DataEvent event, BiFunction<String, List<DataMatrix>, Record[]> actorFn) {
        return (DataEvent)this.context.transactionResult(configuration -> this.run(event, rows -> Jq.argBatch(rows).forEach((table, values) -> {
            this.ensure((String)table, (List<DataMatrix>)values);
            Record[] records = (Record[])actorFn.apply((String)table, (List<DataMatrix>)values);
            this.output((String)table, (List<DataRow>)rows, records);
        })));
    }

    protected <R> DataEvent writeBatch(DataEvent event, BiFunction<String, List<DataMatrix>, R[]> actorFn, Predicate<R[]> testFn) {
        return (DataEvent)this.context.transactionResult(configuration -> this.run(event, rows -> Jq.argBatch(rows).forEach((table, values) -> {
            this.ensure((String)table, (List<DataMatrix>)values);
            Object[] expected = (Object[])actorFn.apply((String)table, (List<DataMatrix>)values);
            this.output(expected, testFn, () -> rows.forEach(row -> row.success((String)table)), () -> new _417DataUnexpectException(this.getClass(), (String)table, expected.toString()));
        })));
    }

    private DataEvent run(DataEvent event, Consumer<List<DataRow>> consumer) {
        try {
            List<DataRow> rows = event.dataRows();
            if (null == rows || rows.isEmpty()) {
                this.logger().error("[ Ox ] \u884c\u5f15\u7528\u4e3a\u7a7a\uff0cDataRow = null\u3002", new Object[0]);
            } else {
                consumer.accept(rows);
            }
        }
        catch (DataAccessException ex) {
            this.logger().fatal((Throwable)ex);
            _417DataTransactionException error = new _417DataTransactionException(this.getClass(), ex);
            event.failure(error);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (!event.succeed().booleanValue()) {
            WebException error = event.getError();
            if (null != error) {
                throw error;
            }
            this.logger().error("[ Ox ] \u5f02\u5e38\u4e3a\u7a7a\uff0c\u4f46\u54cd\u5e94\u4e5f\u975e\u6cd5\u3002success = {0}", new Object[]{event.succeed()});
        }
        return event;
    }

    private void ensure(String table, DataMatrix matrix) {
        Fn.outWeb((boolean)matrix.getAttributes().isEmpty(), (HLogger)this.logger(), _417ConditionEmptyException.class, (Object[])new Object[]{this.getClass(), table});
    }

    private void ensure(String table, List<DataMatrix> matrixes) {
        matrixes.forEach(matrix -> this.ensure(table, (DataMatrix)matrix));
    }

    private <T> void output(T expected, Predicate<T> predicate, Actuator actuator, Supplier<WebException> supplier) {
        if (Objects.isNull(predicate)) {
            actuator.execute();
        } else if (predicate.test(expected)) {
            actuator.execute();
        } else {
            throw supplier.get();
        }
    }

    private void output(String table, List<DataRow> rows, Record[] records) {
        for (int idx = 0; idx < rows.size(); ++idx) {
            DataRow row = rows.get(idx);
            if (null == row) continue;
            if (idx < records.length) {
                Record record = records[idx];
                row.success(table, record, new HashSet<String>());
                continue;
            }
            row.success(table, null, new HashSet<String>());
        }
    }

    private Annal logger() {
        return Annal.get(this.getClass());
    }
}

