/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.horizon.eon.em.modeler.ModelType;
import io.horizon.uca.log.Annal;
import io.vertx.tp.atom.modeling.builtin.DataAtom;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.modeling.element.DataRow;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.error._417TableCounterException;
import io.vertx.tp.modular.query.Ingest;
import io.vertx.up.fn.Fn;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.jooq.DSLContext;
import org.jooq.Record;

abstract class AbstractJQQr {
    protected final transient DSLContext context;

    AbstractJQQr(DSLContext context) {
        this.context = context;
    }

    protected DataEvent aggr(DataEvent event, BiFunction<Set<String>, Ingest, Long> queryFn) {
        return (DataEvent)this.context.transactionResult(configuration -> {
            Ingest ingest = this.ingest(event);
            ConcurrentMap<String, DataMatrix> matrix = this.matrix(this.getClass(), event);
            Long counter = (Long)queryFn.apply(matrix.keySet(), ingest);
            event.stored(counter);
            return event;
        });
    }

    protected DataEvent qr(DataEvent event, BiFunction<Set<String>, Ingest, Record> queryFn) {
        return (DataEvent)this.context.transactionResult(configuration -> {
            Ingest ingest = this.ingest(event);
            ConcurrentMap<String, DataMatrix> matrix = this.matrix(this.getClass(), event);
            DataTpl tpl = event.getTpl();
            Set<String> projection = event.getProjection();
            Record record = (Record)queryFn.apply(matrix.keySet(), ingest);
            event.stored(this.output(matrix.keySet(), new Record[]{record}, tpl, projection));
            return event;
        });
    }

    protected DataEvent qrBatch(DataEvent event, BiFunction<Set<String>, Ingest, Record[]> queryFn, BiFunction<Set<String>, Ingest, Long> countFn) {
        return (DataEvent)this.context.transactionResult(configuration -> {
            Ingest ingest = this.ingest(event);
            ConcurrentMap<String, DataMatrix> matrix = this.matrix(this.getClass(), event);
            DataTpl tpl = event.getTpl();
            Set<String> projection = event.getProjection();
            Record[] records = (Record[])queryFn.apply(matrix.keySet(), ingest);
            event.stored(this.output(matrix.keySet(), records, tpl, projection));
            if (Objects.nonNull(countFn)) {
                Long counter = (Long)countFn.apply(matrix.keySet(), ingest);
                event.stored(counter);
            }
            return event;
        });
    }

    private Ingest ingest(DataEvent event) {
        ModelType type = event.getType();
        Ingest ingest = Ingest.create(type);
        DataAtom atomRef = event.getTpl().atom();
        Ao.LOG.Uca.info(this.getClass(), "\u67e5\u8be2\u89e3\u6790\u5668\uff1a{0}\uff0c\u64cd\u4f5c\u6a21\u578b\uff1a{1}", new Object[]{null == ingest ? null : ingest.getClass().getName(), atomRef.identifier()});
        return ingest;
    }

    private ConcurrentMap<String, DataMatrix> matrix(Class<?> clazz, DataEvent event) {
        ModelType type = event.getType();
        DataTpl tpl = event.getTpl();
        ConcurrentMap<String, DataMatrix> matrix = tpl.matrixData();
        if (ModelType.DIRECT == type) {
            Fn.outWeb((1 != matrix.size() ? 1 : 0) != 0, _417TableCounterException.class, (Object[])new Object[]{clazz, matrix.size()});
        } else if (ModelType.JOINED == type) {
            Fn.outWeb((1 >= matrix.size() ? 1 : 0) != 0, _417TableCounterException.class, (Object[])new Object[]{clazz, matrix.size()});
        }
        return matrix;
    }

    private List<DataRow> output(Set<String> tableSet, Record[] records, DataTpl tpl, Set<String> projection) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (Record record : records) {
            DataRow row = new DataRow(tpl);
            tableSet.forEach(table -> row.success((String)table, record, projection));
            rows.add(row);
        }
        return rows;
    }

    private Annal logger() {
        return Annal.get(this.getClass());
    }
}

