/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.modular.jooq.AbstractJQCrud;
import io.vertx.tp.modular.jooq.internal.Jq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jooq.Batch;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DeleteUsingStep;
import org.jooq.DeleteWhereStep;

class JQDelete
extends AbstractJQCrud {
    JQDelete(DSLContext context) {
        super(context);
    }

    DataEvent delete(DataEvent event) {
        return this.write(event, (table, matrix) -> {
            DeleteWhereStep query = this.stepDelete((String)table, (DataMatrix)matrix);
            return query.execute();
        }, null);
    }

    DataEvent deleteBatch(DataEvent event) {
        return this.writeBatch(event, (table, matrix) -> {
            Batch batch = this.prepareBatch((String)table, (List<DataMatrix>)matrix);
            ArrayList result = new ArrayList();
            Arrays.stream(batch.execute()).forEach(result::add);
            return result.toArray(new Integer[0]);
        }, null);
    }

    private Batch prepareBatch(String table, List<DataMatrix> matrices) {
        ArrayList batchOps = new ArrayList();
        matrices.stream().map(matrix -> this.stepDelete(table, (DataMatrix)matrix)).forEach(batchOps::add);
        return this.context.batch(batchOps);
    }

    private DeleteWhereStep stepDelete(String table, DataMatrix matrix) {
        DeleteUsingStep query = this.context.deleteFrom(Jq.toTable(table));
        Condition condition = Jq.inWhere(matrix);
        query.where(condition);
        return query;
    }
}

